/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

public enum LinkQuality {
    BAD(0, "Poor signal quality (causes increased power consumption)"),
    AVERAGE(1, "Average signal quality (causes increased power consumption)"),
    GOOD(2, "Good signal quality"),
    PERFECT(3, "Perfect signal quality");

    private final int qualityLevel;
    private final String description;

    private LinkQuality(int qualityLevel, String description) {
        this.qualityLevel = qualityLevel;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getQualityLevel() {
        return this.qualityLevel;
    }

    public static LinkQuality valueOf(int qualityLevel) {
        for (LinkQuality linkQuality : LinkQuality.values()) {
            if (qualityLevel != linkQuality.qualityLevel) continue;
            return linkQuality;
        }
        throw new IllegalArgumentException("Invalid link quality level " + qualityLevel);
    }
}

