/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.wireless.Address;
import java.util.UUID;
import org.joda.time.DateTime;

public class LabelEvent
implements Comparable<LabelEvent> {
    private final UUID eventId;
    private final Address labelAddress;
    private DateTime receivedTime;
    private int eventType;
    private int eventData;
    private int revision;
    private boolean confirmed;

    public LabelEvent(UUID eventId, Address labelAddress, DateTime receivedTime, int eventType, int eventData) {
        this.eventId = eventId;
        this.labelAddress = labelAddress;
        this.receivedTime = receivedTime;
        this.eventType = eventType;
        this.eventData = eventData;
        this.revision = 0;
        this.confirmed = false;
    }

    public LabelEvent(UUID eventId, Address labelAddress, DateTime receivedTime, int eventType, int eventData, int revision, boolean confirmed) {
        this.eventId = eventId;
        this.labelAddress = labelAddress;
        this.receivedTime = receivedTime;
        this.eventType = eventType;
        this.eventData = eventData;
        this.revision = revision;
        this.confirmed = confirmed;
    }

    public LabelEvent(LabelEvent otherEvent) {
        this.eventId = otherEvent.eventId;
        this.labelAddress = otherEvent.labelAddress;
        this.receivedTime = otherEvent.receivedTime;
        this.eventType = otherEvent.eventType;
        this.eventData = otherEvent.eventData;
        this.revision = otherEvent.revision;
        this.confirmed = otherEvent.confirmed;
    }

    public Address getLabelAddress() {
        return this.labelAddress;
    }

    public DateTime getReceivedTime() {
        return this.receivedTime;
    }

    public UUID getEventId() {
        return this.eventId;
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getEventData() {
        return this.eventData;
    }

    public int getRevision() {
        return this.revision;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void confirmEvent() {
        this.confirmed = true;
        ++this.revision;
    }

    public boolean isDifferentFrom(LabelEvent otherEvent) {
        return this.revision != otherEvent.revision;
    }

    public void takeDataFrom(LabelEvent otherEvent) {
        this.receivedTime = otherEvent.receivedTime;
        this.eventData = otherEvent.eventData;
        this.eventType = otherEvent.eventType;
        this.confirmed = otherEvent.confirmed;
        this.revision = otherEvent.revision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventId == null ? 0 : this.eventId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelEvent other = (LabelEvent)obj;
        return !(this.eventId == null ? other.eventId != null : !this.eventId.equals(other.eventId));
    }

    @Override
    public int compareTo(LabelEvent o) {
        return this.eventId.compareTo(o.eventId);
    }
}

