/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.toolkit.InitializationException;
import java.io.File;

public class ESLProperties {
    private static final String KEYSTORE_PATH = "config/certificate.keystore";
    private static final String KEYSTORE_PASSWORD = "imagotag";
    public static final String KEYSTORE_PROPERTY = "javax.net.ssl.keyStore";
    public static final String KEYSTORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    public static final String TRUSTSTORE_DEFAULT_PATH = String.format("%s%s", System.getProperty("java.home"), "/lib/security/cacerts".replace('/', File.separatorChar));
    private static final String TRUSTSTORE_DEFAULT_PASSOWRD = "changeit";
    private static final String TRUSTSTORE_PATH = "config/certificate.truststore";
    private static final String TRUSTSTORE_PASSOWRD = "imagotag";
    public static final String TRUSTSTORE_FILE_PROPERTY = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static final String PROVISIONING_KEYSTORE_FILE_PROPERTY = "com.imagotag.ssl.provisioning.keyStore";
    public static final String PROVISIONING_KEYSTORE_PASSWORD_PROPERTY = "com.imagotag.ssl.provisioning.keyStorePassword";
    public static final String APPLIANCE_PROVISIONING_KEYSTORE_PATH = "/esl-config/certificate/provisioning.keystore";
    public static final String ACCESS_POINT_PROVISIONING_KEYSTORE_PATH = "/esl/security/provisioning.keystore";
    private static final String PROVISIONING_KEYSTORE_PASSWORD = "imagotag";
    public static final String PROVISIONING_TRUSTSTORE_FILE_PROPERTY = "com.imagotag.ssl.provisioning.trustStore";
    public static final String PROVISIONING_TRUSTSTORE_PASSWORD_PROPERTY = "com.imagotag.ssl.provisioning.trustStorePassword";
    public static final String ACCESS_POINT_KEYSTORE_PATH = "/esl/security/certificate.keystore";
    public static final String ACCESS_POINT_TRUSTSTORE_PATH = "/esl/security/certificate.truststore";

    public static void setKeyStore() {
        String customPath = System.getProperty(KEYSTORE_PROPERTY);
        String keyStorePath = customPath != null && !customPath.isEmpty() ? customPath : KEYSTORE_PATH;
        String customPassword = System.getProperty(KEYSTORE_PASSWORD_PROPERTY);
        String keyStorePassword = customPassword != null && !customPassword.isEmpty() ? customPassword : "imagotag";
        System.setProperty(KEYSTORE_PROPERTY, keyStorePath);
        System.setProperty(KEYSTORE_PASSWORD_PROPERTY, keyStorePassword);
    }

    public static void setTrustStore(boolean useDefault) {
        if (useDefault) {
            System.setProperty(TRUSTSTORE_FILE_PROPERTY, TRUSTSTORE_DEFAULT_PATH);
            System.setProperty(TRUSTSTORE_PASSWORD_PROPERTY, TRUSTSTORE_DEFAULT_PASSOWRD);
        } else {
            String customPath = System.getProperty(TRUSTSTORE_FILE_PROPERTY);
            String trustStorePath = customPath != null && !customPath.isEmpty() ? customPath : TRUSTSTORE_PATH;
            String customPassword = System.getProperty(TRUSTSTORE_PASSWORD_PROPERTY);
            String trustStorePassword = customPassword != null && !customPassword.isEmpty() ? customPassword : "imagotag";
            System.setProperty(TRUSTSTORE_FILE_PROPERTY, trustStorePath);
            System.setProperty(TRUSTSTORE_PASSWORD_PROPERTY, trustStorePassword);
        }
    }

    public static void setProvisioningKeyStore(DeviceMode deviceMode) {
        String customPath = System.getProperty(PROVISIONING_KEYSTORE_FILE_PROPERTY);
        String customPassword = System.getProperty(PROVISIONING_KEYSTORE_PASSWORD_PROPERTY);
        String keyStorePath = customPath != null && !customPath.isEmpty() ? customPath : (deviceMode == DeviceMode.CORE_APPLIANCE ? APPLIANCE_PROVISIONING_KEYSTORE_PATH : ACCESS_POINT_PROVISIONING_KEYSTORE_PATH);
        String keyStorePassword = customPassword != null && !customPassword.isEmpty() ? customPassword : "imagotag";
        System.setProperty(PROVISIONING_KEYSTORE_FILE_PROPERTY, keyStorePath);
        System.setProperty(PROVISIONING_KEYSTORE_PASSWORD_PROPERTY, keyStorePassword);
    }

    public static void setProvisioningTrustStore() throws InitializationException {
        String customPath = System.getProperty(PROVISIONING_TRUSTSTORE_FILE_PROPERTY);
        String trustStorePath = customPath != null && !customPath.isEmpty() ? customPath : TRUSTSTORE_DEFAULT_PATH;
        String customPassword = System.getProperty(PROVISIONING_TRUSTSTORE_PASSWORD_PROPERTY);
        String trustStorePassword = customPassword != null && !customPassword.isEmpty() ? customPassword : TRUSTSTORE_DEFAULT_PASSOWRD;
        System.setProperty(PROVISIONING_TRUSTSTORE_FILE_PROPERTY, trustStorePath);
        System.setProperty(PROVISIONING_TRUSTSTORE_PASSWORD_PROPERTY, trustStorePassword);
    }
}

