/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.OneTimeTaskExecutor;
import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ReloadRunner;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.List;

public abstract class DefaultPeriodicTasksExecutor
implements PeriodicTasksExecutor {
    static ESLLogger logger = ESLLogger.getLogger(DefaultPeriodicTasksExecutor.class);
    private final List<ESLProcessingTask> processingTasks = new ArrayList<ESLProcessingTask>();
    private final boolean interruptOnShutdown;
    private final OneTimeTaskExecutor oneTimeTaskExecutor;
    private Shutdownable reloadThread;

    public DefaultPeriodicTasksExecutor() {
        this(true, null);
    }

    public DefaultPeriodicTasksExecutor(OneTimeTaskExecutor oneTimeTaskExecutor) {
        this(true, oneTimeTaskExecutor);
    }

    public DefaultPeriodicTasksExecutor(boolean interruptOnShutdown) {
        this.interruptOnShutdown = interruptOnShutdown;
        this.oneTimeTaskExecutor = null;
    }

    public DefaultPeriodicTasksExecutor(boolean interruptOnShutdown, OneTimeTaskExecutor oneTimeTaskExecutor) {
        this.interruptOnShutdown = interruptOnShutdown;
        this.oneTimeTaskExecutor = oneTimeTaskExecutor;
    }

    public void addProcessingTask(ESLProcessingTask processingTask) {
        this.processingTasks.add(processingTask);
    }

    public void start() {
        this.reloadThread = ReloadRunner.startInBackground(new ReloadRunner(this, this.oneTimeTaskExecutor){

            @Override
            protected long getReloadTime() {
                return DefaultPeriodicTasksExecutor.this.getReloadTime();
            }
        }, this.interruptOnShutdown);
    }

    public void shutdown() {
        if (this.reloadThread != null) {
            logger.info("Shutdown %s thread", new Object[]{this.getClass().getName()});
            this.reloadThread.shutdown();
        }
    }

    @Override
    public void performPeriodicTasks() {
        for (ESLProcessingTask processingTask : this.processingTasks) {
            try {
                processingTask.run();
            }
            catch (WebserviceException exc) {
                logger.error("Could not connect to access point (%s)", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (DatasetException exc) {
                logger.error("Could not persist to database (%s)", new Object[]{exc.getMessage()});
                logger.logException((Throwable)exc);
            }
            catch (SerializeException exc) {
                logger.error("Could not create tasks for access point (%s)", new Object[]{exc.getMessage()});
                logger.logException((Throwable)exc);
            }
            catch (Exception exc) {
                logger.error("Unknown exception during service task processing (%s)", new Object[]{exc.getMessage()});
                logger.logException((Throwable)exc);
            }
        }
        logger.debug("Finished periodic tasks");
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    public abstract long getReloadTime();
}

