/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.OneTimeTaskExecutor;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DefaultOneTimeTaskExecutor
implements OneTimeTaskExecutor {
    private static ESLLogger logger = ESLLogger.getLogger(DefaultOneTimeTaskExecutor.class);
    private final LinkedBlockingQueue<ESLProcessingTask> taskQueue = new LinkedBlockingQueue();
    private volatile boolean shutdownRequested = false;

    protected void putOnQueue(ESLProcessingTask newTask) {
        if (!this.taskQueue.offer(newTask)) {
            logger.error("One time task executor queue is full!!!");
        }
    }

    @Override
    public void waitForAndPerformTasks(long waitTimeInMs) {
        try {
            long startTime = System.currentTimeMillis();
            ESLProcessingTask newTask = this.taskQueue.poll();
            block3: while (!this.shutdownRequested) {
                while (newTask != null) {
                    newTask.run();
                    newTask = this.taskQueue.poll();
                }
                long elapsedTime = System.currentTimeMillis() - startTime;
                while (!this.shutdownRequested && waitTimeInMs > elapsedTime) {
                    newTask = this.taskQueue.poll(waitTimeInMs - elapsedTime > 5000L ? 5000L : waitTimeInMs - elapsedTime, TimeUnit.MILLISECONDS);
                    if (newTask != null) continue block3;
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                break;
            }
        }
        catch (InterruptedException ignore) {
        }
        catch (Exception exc) {
            logger.error("Unknown exception during one time task processing (%s)", new Object[]{exc.getMessage()});
            logger.logException((Throwable)exc);
        }
    }

    public void shutdown() {
        this.shutdownRequested = true;
    }
}

