/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public enum ConnectionStatus {
    ONLINE("Device is connected"),
    DISCOVERED("New device discovered (access points only)"),
    UNKNOWN("Could not determine connection status"),
    OFFLINE("Device is not connected");

    private final String description;

    private ConnectionStatus(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOnline() {
        return this == ONLINE;
    }

    public boolean isDiscovered() {
        return this == DISCOVERED;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public boolean isOffline() {
        return this == OFFLINE;
    }

    public static ConnectionStatus fromString(String value) {
        return ConnectionStatus.valueOf(value.toUpperCase());
    }

    public static ConnectionStatus valueOf(boolean status) {
        return status ? ONLINE : OFFLINE;
    }

    public static ConnectionStatus getStatus(DateTime now, DateTime lastSeenTime, int offlineAfterSeconds) {
        return lastSeenTime != null ? ConnectionStatus.valueOf(Seconds.secondsBetween((ReadableInstant)lastSeenTime, (ReadableInstant)now).getSeconds() < offlineAfterSeconds) : OFFLINE;
    }
}

