/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.toolkit.sql.SqlUtils;

public enum AccessPointUpdateStatus {
    SUCCESSFUL("AP update was successful"),
    FAILED("The update attempt failed"),
    ERROR("AP update processing failed"),
    DELAYED("Update has been delayed"),
    WAITING("Update is waiting for processing");

    public static final String UNFINISHED_SQL;
    private final String description;

    private AccessPointUpdateStatus(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isFinished() {
        return this != WAITING && this != DELAYED;
    }

    public boolean isSuccessful() {
        return this == SUCCESSFUL;
    }

    public boolean isWaiting() {
        return this == WAITING;
    }

    public boolean isDelayed() {
        return this == DELAYED;
    }

    static {
        UNFINISHED_SQL = SqlUtils.getSqlCondition((Object[])new Object[]{WAITING, DELAYED});
    }
}

