/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import at.mrdevelopment.esl.certificate.AbstractStore;
import at.mrdevelopment.esl.certificate.CertificateProperties;
import at.mrdevelopment.esl.certificate.DuplicateCertificateException;
import at.mrdevelopment.toolkit.InitializationException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;

public class ProvisioningKeyStore
extends AbstractStore {
    private static ProvisioningKeyStore instance;
    private static final int DEFAULT_CERTIFICATE_VALIDITY = 100;
    private static final String CERTIFICATE_ALIAS = "imagotag-provisioning";

    public static synchronized void initialize(boolean readOnly) throws InitializationException {
        if (instance == null) {
            instance = new ProvisioningKeyStore(readOnly);
        }
    }

    public static synchronized void initialize(String hostname) throws InitializationException {
        instance = new ProvisioningKeyStore(hostname);
    }

    public static void reinitialize(boolean readOnly) throws InitializationException {
        instance = new ProvisioningKeyStore(readOnly);
    }

    public static synchronized ProvisioningKeyStore getInstance() throws InitializationException {
        if (instance == null) {
            instance = new ProvisioningKeyStore();
        }
        return instance;
    }

    private ProvisioningKeyStore() throws InitializationException {
        super("com.imagotag.ssl.provisioning.keyStore", "com.imagotag.ssl.provisioning.keyStorePassword", false);
    }

    private ProvisioningKeyStore(boolean readOnly) throws InitializationException {
        super("com.imagotag.ssl.provisioning.keyStore", "com.imagotag.ssl.provisioning.keyStorePassword", readOnly);
    }

    private ProvisioningKeyStore(String hostname) throws InitializationException {
        super("com.imagotag.ssl.provisioning.keyStore", "com.imagotag.ssl.provisioning.keyStorePassword", hostname, false);
    }

    @Override
    protected boolean createKeyStore(KeyStore keyStore) throws KeyStoreException, InvalidKeyException, NoSuchAlgorithmException, SecurityException, SignatureException {
        if (!keyStore.containsAlias(CERTIFICATE_ALIAS)) {
            this.generateAndStoreKeyPair(keyStore, CERTIFICATE_ALIAS);
        }
        return keyStore.getCertificate(CERTIFICATE_ALIAS) != null;
    }

    @Override
    public CertificateProperties getDefaultProperties() {
        return new CertificateProperties("AT", this.hostname, "SES-imagotag GmbH", "None", "Graz", "Styria", 100);
    }

    @Override
    public void importCertificate(String alias, Certificate certificate) throws KeyStoreException, DuplicateCertificateException {
        throw new KeyStoreException("Importing certificates not allowed.");
    }

    @Override
    public void deleteCertificate(String alias) throws KeyStoreException {
        throw new KeyStoreException("Deleting certificates not allowed.");
    }

    public String getProvisioningCertificatePEM() throws KeyStoreException, IOException {
        return this.writePEM(this.getProvisioningCertificate());
    }

    public Certificate getProvisioningCertificate() throws KeyStoreException {
        return this.keyStore.getCertificate(CERTIFICATE_ALIAS);
    }
}

