/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import at.mrdevelopment.esl.certificate.ESLKeyStore;
import at.mrdevelopment.esl.toolkit.file.DynamicFileLoader;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class P12Importer
extends DynamicFileLoader {
    static ESLLogger logger = ESLLogger.getLogger(P12Importer.class);

    public P12Importer(File ... locations) throws InitializationException {
        super((Collection)Lists.newArrayList((Object[])new String[]{"p12", "key"}), locations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFiles(List<File> files) throws Exception {
        ESLKeyStore keyStore = ESLKeyStore.getInstance();
        for (File p12File : files) {
            if (!FilenameUtils.isExtension((String)p12File.getName(), (String)"p12")) continue;
            for (File keyFile : files) {
                List keyLines;
                String containerName;
                String keyName = FilenameUtils.removeExtension((String)keyFile.getName());
                if (!keyName.equals(containerName = FilenameUtils.removeExtension((String)p12File.getName())) || !FilenameUtils.isExtension((String)keyFile.getName(), (String)"key") || (keyLines = FileUtils.readLines((File)keyFile)).size() <= 0) continue;
                String key = (String)keyLines.get(0);
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(p12File);
                    logger.info("Importing certificate container from files %s and %s", new Object[]{p12File.getName(), keyFile.getName()});
                    keyStore.importCertificateContainer(inputStream, key);
                    logger.info("Imported certificate from p12 container");
                }
                catch (Throwable throwable) {
                    StreamUtils.close(inputStream);
                    throw throwable;
                }
                StreamUtils.close((InputStream)inputStream);
            }
        }
    }
}

