/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import at.mrdevelopment.esl.certificate.AbstractStore;
import at.mrdevelopment.esl.core.ESLProperties;
import at.mrdevelopment.toolkit.InitializationException;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;

public class ESLTrustStore
extends AbstractStore {
    private static ESLTrustStore instance;

    public static synchronized ESLTrustStore getInstance() throws InitializationException {
        if (instance == null) {
            instance = new ESLTrustStore();
        }
        return instance;
    }

    private ESLTrustStore() throws InitializationException {
        super("javax.net.ssl.trustStore", "javax.net.ssl.trustStorePassword", ESLTrustStore.isDefaultJavaTrustStore());
    }

    private ESLTrustStore(String storeFileProperty, String storePasswordProperty, String hostname) throws InitializationException {
        super("javax.net.ssl.trustStore", "javax.net.ssl.trustStorePassword", hostname, ESLTrustStore.isDefaultJavaTrustStore());
    }

    @Override
    protected boolean createKeyStore(KeyStore keyStore) throws KeyStoreException, InvalidKeyException, NoSuchAlgorithmException, SecurityException, SignatureException {
        return !new File(System.getProperty("javax.net.ssl.trustStore")).exists();
    }

    private static boolean isDefaultJavaTrustStore() {
        return ESLProperties.TRUSTSTORE_DEFAULT_PATH.equals(System.getProperty("javax.net.ssl.trustStore"));
    }
}

