/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import at.mrdevelopment.esl.certificate.ESLKeyStore;
import at.mrdevelopment.esl.certificate.ESLTrustStore;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ESLTrustManager
implements X509TrustManager {
    static ESLLogger logger = ESLLogger.getLogger(ESLTrustManager.class);
    private final Collection<X509TrustManager> defaultTrustManagers;
    private final boolean strictVerification;
    private final boolean verifyClientCertificates;

    public ESLTrustManager(boolean strictVerification, boolean verifyClientCertificates) throws InitializationException {
        this(strictVerification, verifyClientCertificates, true);
    }

    public ESLTrustManager(boolean strictVerification, boolean verifyClientCertificates, boolean loadCustomTrustManagers) throws InitializationException {
        this(strictVerification, verifyClientCertificates, loadCustomTrustManagers, new KeyStore[]{ESLTrustStore.getInstance().getKeyStore()});
    }

    public ESLTrustManager(boolean strictVerification, boolean verifyClientCertificates, boolean loadCustomTrustManagers, KeyStore[] keyStores) throws InitializationException {
        this.strictVerification = strictVerification;
        this.verifyClientCertificates = verifyClientCertificates;
        this.defaultTrustManagers = new HashSet<X509TrustManager>();
        if (loadCustomTrustManagers) {
            this.loadTrustManagers(ESLKeyStore.getInstance().getKeyStore());
        }
        for (KeyStore keyStore : keyStores) {
            try {
                this.loadTrustManagers(keyStore);
            }
            catch (InitializationException exc) {
                logger.warn("Could not load ESL trust store: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
    }

    private void loadTrustManagers(KeyStore keyStore) throws InitializationException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            TrustManager[] tms = trustManagerFactory.getTrustManagers();
            for (int index = 0; index < tms.length; ++index) {
                if (!(tms[index] instanceof X509TrustManager)) continue;
                this.defaultTrustManagers.add((X509TrustManager)tms[index]);
            }
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.defaultTrustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException exc) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Trustmanager does not trust client certificate (%s): %s", new Object[]{trustManager.toString(), exc.getMessage()});
            }
        }
        if (this.verifyClientCertificates) {
            throw new CertificateException("Client certificate not trusted");
        }
        logger.debug("Client certificate not trusted");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.defaultTrustManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException exc) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Trustmanager does not trust server certificate (%s): %s", new Object[]{trustManager.toString(), exc.getMessage()});
            }
        }
        if (this.strictVerification) {
            throw new CertificateException("Server certificate not trusted");
        }
        logger.debug("Server certificate not trusted");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (X509TrustManager trustManager : this.defaultTrustManagers) {
            certificates.addAll(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return certificates.toArray(new X509Certificate[certificates.size()]);
    }
}

