/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import at.mrdevelopment.esl.certificate.AbstractStore;
import at.mrdevelopment.esl.certificate.CertificateProperties;
import at.mrdevelopment.esl.certificate.InvalidCertifcateKeyException;
import at.mrdevelopment.esl.core.ESLProperties;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.util.Arrays;

public class ESLKeyStore
extends AbstractStore {
    public static ESLKeyStore instance;
    public static ESLKeyStore readOnlyInstance;
    private static final String internalAliasCertificate = "imagotag";
    private static final String internalAliasKeys = "imagotag";

    public static synchronized ESLKeyStore getInstance() throws InitializationException {
        if (instance == null) {
            instance = new ESLKeyStore(false);
        }
        return instance;
    }

    public static synchronized ESLKeyStore getReadOnlyInstance() throws InitializationException {
        if (readOnlyInstance == null) {
            readOnlyInstance = new ESLKeyStore(true);
        }
        return readOnlyInstance;
    }

    private ESLKeyStore(boolean readOnly) throws InitializationException {
        super("javax.net.ssl.keyStore", "javax.net.ssl.keyStorePassword", AbstractStore.getHostName(), readOnly);
    }

    private ESLKeyStore(String hostname) throws InitializationException {
        super("javax.net.ssl.keyStore", "javax.net.ssl.keyStorePassword", hostname, false);
    }

    @Override
    protected boolean createKeyStore(KeyStore keyStore) throws KeyStoreException, InvalidKeyException, NoSuchAlgorithmException, SecurityException, SignatureException {
        if (!keyStore.containsAlias("imagotag")) {
            this.generateAndStoreKeyPair(keyStore, "imagotag");
        }
        return keyStore.getCertificate("imagotag") != null;
    }

    public void createSelfSignedCertificate() throws InvalidKeyException, KeyStoreException, SecurityException, SignatureException, UnrecoverableKeyException, NoSuchAlgorithmException {
        KeyPair keyPair = this.getKeyPair();
        this.keyStore.setKeyEntry("imagotag", keyPair.getPrivate(), System.getProperty(this.storePasswordProperty).toCharArray(), new Certificate[]{this.createSelfSignedCertificate(this.getDefaultProperties(), keyPair)});
        this.save();
    }

    public void importCertificate(X509Certificate certificate) throws KeyStoreException {
        this.keyStore.setCertificateEntry("imagotag", certificate);
    }

    public Certificate getCertificate() throws KeyStoreException, InvalidKeyException, NoSuchAlgorithmException, SecurityException, SignatureException {
        if (!this.keyStore.containsAlias("imagotag")) {
            this.generateAndStoreKeyPair(this.keyStore, "imagotag");
        }
        return this.keyStore.getCertificate("imagotag");
    }

    @Override
    public CertificateProperties getDefaultProperties() {
        return new CertificateProperties("AT", this.hostname, "SES-imagotag GmbH", "None", "Graz", "Styria", 20);
    }

    public PKCS10CertificationRequest getCertificationRequest(CertificateProperties properties) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException, UnrecoverableKeyException {
        KeyPair keyPair = this.getKeyPair();
        X500Principal subjectName = new X500Principal(properties.toString());
        PKCS10CertificationRequest certificationRequest = new PKCS10CertificationRequest("MD5withRSA", subjectName, keyPair.getPublic(), null, keyPair.getPrivate());
        return certificationRequest;
    }

    private KeyPair getKeyPair() throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, InvalidKeyException, SecurityException, SignatureException {
        Key key;
        if (!this.keyStore.containsAlias("imagotag")) {
            this.generateAndStoreKeyPair(this.keyStore, "imagotag");
        }
        if ((key = this.keyStore.getKey("imagotag", System.getProperty("javax.net.ssl.keyStorePassword").toCharArray())) != null && key instanceof PrivateKey) {
            Certificate cert = this.keyStore.getCertificate("imagotag");
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, (PrivateKey)key);
        }
        return null;
    }

    public void createAndStoreSelfSignedCertificate(CertificateProperties properties) throws InvalidKeyException, UnrecoverableKeyException, SecurityException, SignatureException, KeyStoreException, NoSuchAlgorithmException {
        KeyPair keyPair = this.getKeyPair();
        Certificate certificate = this.createSelfSignedCertificate(properties, keyPair);
        this.keyStore.setKeyEntry("imagotag", keyPair.getPrivate(), System.getProperty("javax.net.ssl.keyStorePassword").toCharArray(), new Certificate[]{certificate});
        this.save();
    }

    public String getPrivateKeyPEM() throws UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, IOException {
        return this.writePEM(this.getKeyPair().getPrivate());
    }

    public String getPublicKeyPEM() throws UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, IOException {
        return this.writePEM(this.getKeyPair().getPublic());
    }

    public String getCertificatePEM() throws KeyStoreException, IOException, InvalidKeyException, NoSuchAlgorithmException, SecurityException, SignatureException {
        return this.writePEM(this.getCertificate());
    }

    public byte[] getCertificateDER() throws InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, CertificateEncodingException {
        return this.writeDER(this.getCertificate());
    }

    private byte[] writeDER(Certificate certificate) throws CertificateEncodingException {
        byte[] encoded = certificate.getEncoded();
        byte[] destination = new byte[encoded.length];
        System.arraycopy(encoded, 0, destination, 0, encoded.length);
        return destination;
    }

    private byte[] writeDER(PKCS10CertificationRequest csr) throws CertificateEncodingException {
        byte[] encoded = csr.getEncoded();
        byte[] destination = new byte[encoded.length];
        System.arraycopy(encoded, 0, destination, 0, encoded.length);
        return destination;
    }

    public void setKeyPairFromPEM(String publicKey, String privateKey) throws IOException, InvalidKeyException, KeyStoreException, SecurityException, SignatureException {
        publicKey = this.cleanKey(publicKey);
        privateKey = this.cleanKey(privateKey);
        Object pkey = this.readPEM(privateKey);
        KeyPair keyPair = null;
        if (pkey instanceof KeyPair) {
            keyPair = (KeyPair)pkey;
        } else if (pkey instanceof PrivateKey) {
            keyPair = new KeyPair((PublicKey)this.readPEM(publicKey), (PrivateKey)pkey);
        } else {
            throw new IllegalArgumentException();
        }
        this.keyStore.setKeyEntry("imagotag", keyPair.getPrivate(), System.getProperty("javax.net.ssl.keyStorePassword").toCharArray(), new Certificate[]{this.createSelfSignedCertificate(this.getDefaultProperties(), keyPair)});
        this.save();
    }

    private String cleanKey(String pemKey) {
        if (pemKey.contains("\n")) {
            return pemKey;
        }
        pemKey = pemKey.replace("-----BEGIN PUBLIC KEY-----", "-----BEGIN PUBLIC KEY-----\n");
        pemKey = pemKey.replace("-----BEGIN RSA PRIVATE KEY-----", "-----BEGIN RSA PRIVATE KEY-----\n");
        pemKey = pemKey.replace("-----END", "\n-----END");
        return pemKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readPEM(String data) throws IOException {
        Object object;
        PEMReader reader = null;
        try {
            reader = new PEMReader((Reader)new StringReader(data));
            object = reader.readObject();
        }
        catch (Throwable throwable) {
            StreamUtils.close(reader);
            throw throwable;
        }
        StreamUtils.close((Reader)reader);
        return object;
    }

    public String getCertificationRequestPEM() throws InvalidKeyException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException, IOException {
        return this.writePEM(this.getCertificationRequest(this.getDefaultProperties()));
    }

    public String getCertificationRequestPEM(CertificateProperties properties) throws InvalidKeyException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException, IOException {
        return this.writePEM(this.getCertificationRequest(properties));
    }

    public byte[] getCertificationRequestDER(CertificateProperties properties) throws CertificateEncodingException, InvalidKeyException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException {
        return this.writeDER(this.getCertificationRequest(properties));
    }

    public String getFingerprint() throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(this.getKeyPair().getPublic().getEncoded());
        return new String(Hex.encodeHex((byte[])md.digest()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importCertificates(File[] certificateFiles) throws UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, IOException, CertificateException {
        Certificate[] certificateArray;
        ArrayList<? extends Certificate> certificates = new ArrayList<Certificate>();
        for (File certificateFile : certificateFiles) {
            if (FilenameUtils.isExtension((String)certificateFile.getName(), (String)"pem")) {
                certificates.addAll(this.readCertificate(certificateFile));
                continue;
            }
            if (!FilenameUtils.isExtension((String)certificateFile.getName(), (String)"der")) continue;
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(certificateFile);
                certificates.addAll(CertificateFactory.getInstance("X.509").generateCertificates(stream));
            }
            catch (Throwable throwable) {
                StreamUtils.close(stream);
                throw throwable;
            }
            StreamUtils.close((InputStream)stream);
        }
        KeyPair keyPair = this.getKeyPair();
        if (certificates.isEmpty()) {
            Certificate[] certificateArray2 = new Certificate[1];
            certificateArray = certificateArray2;
            certificateArray2[0] = this.createSelfSignedCertificate(this.getDefaultProperties(), keyPair);
        } else {
            certificateArray = certificates.toArray(new Certificate[certificates.size()]);
        }
        Certificate[] chain = certificateArray;
        this.keyStore.setKeyEntry("imagotag", keyPair.getPrivate(), System.getProperty("javax.net.ssl.keyStorePassword").toCharArray(), chain);
        this.save();
        return certificates.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Certificate> readCertificate(File file) throws IOException, UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException {
        PEMReader pemReader = null;
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        try {
            pemReader = new PEMReader((Reader)new FileReader(file));
            while (pemReader.ready()) {
                Object obj = pemReader.readObject();
                if (!(obj instanceof Certificate)) continue;
                certificates.add((Certificate)obj);
            }
        }
        catch (Throwable throwable) {
            StreamUtils.close(pemReader);
            throw throwable;
        }
        StreamUtils.close((Reader)pemReader);
        return certificates;
    }

    public void importCertificateContainer(InputStream inputStream, String passwordString) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        if (passwordString == null) {
            throw new CertificateException("Password cannot be null for certificate container");
        }
        KeyStore pkcs12KeyStore = KeyStore.getInstance("PKCS12");
        char[] password = passwordString.toCharArray();
        pkcs12KeyStore.load(inputStream, password);
        Enumeration<String> aliasEnum = pkcs12KeyStore.aliases();
        Key privateKey = null;
        Certificate certificate = null;
        while (aliasEnum.hasMoreElements()) {
            String keyName = aliasEnum.nextElement();
            privateKey = pkcs12KeyStore.getKey(keyName, password);
            certificate = pkcs12KeyStore.getCertificate(keyName);
        }
        if (certificate != null && privateKey != null && privateKey instanceof PrivateKey) {
            this.keyStore.setKeyEntry("imagotag", (PrivateKey)privateKey, System.getProperty("javax.net.ssl.keyStorePassword").toCharArray(), new Certificate[]{certificate});
            this.save();
        }
    }

    public int importCertificates(Collection<Certificate> certificates) throws CertificateEncodingException, UnrecoverableKeyException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, InvalidCertifcateKeyException, KeyStoreException, SecurityException {
        Certificate installedCertificate = this.getCertificate();
        for (Certificate certificate : certificates) {
            if (Arrays.areEqual((byte[])certificate.getEncoded(), (byte[])installedCertificate.getEncoded())) continue;
            try {
                installedCertificate.verify(certificate.getPublicKey());
            }
            catch (InvalidKeyException exc) {
                throw new InvalidCertifcateKeyException(exc);
            }
        }
        if (certificates.size() > 0) {
            this.keyStore.setKeyEntry("imagotag", this.getKeyPair().getPrivate(), System.getProperty("javax.net.ssl.keyStorePassword").toCharArray(), certificates.toArray(new Certificate[certificates.size()]));
            this.save();
        }
        return certificates.size();
    }

    public boolean isCertifcateSelfSigned() throws InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException {
        return this.isCertificateSelfSigned((X509Certificate)this.getCertificate());
    }

    public static boolean doesKeyStoreExist() {
        File file = new File(System.getProperty("javax.net.ssl.keyStore"));
        return file.exists();
    }

    public Certificate[] getCertificateChain() throws KeyStoreException {
        return this.keyStore.getCertificateChain("imagotag");
    }

    public String getCertificateChainPEM() throws KeyStoreException, IOException {
        return this.writePEM(this.getCertificateChain());
    }

    static {
        ESLProperties.setKeyStore();
    }
}

