/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import at.mrdevelopment.esl.certificate.ESLKeyStore;
import at.mrdevelopment.toolkit.InitializationException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public class ESLKeyManagerFactory {
    private final KeyManagerFactory keyManagerFactory;

    public ESLKeyManagerFactory() throws InitializationException {
        this(ESLKeyStore.getInstance().getKeyStore(), System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public ESLKeyManagerFactory(KeyStore keyStore, String keyStorePassword) throws InitializationException {
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        }
        catch (NoSuchAlgorithmException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (UnrecoverableKeyException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (KeyStoreException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagerFactory.getKeyManagers();
    }
}

