/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.openssl.PEMReader;

public class CertificateParser {
    static ESLLogger logger = ESLLogger.getLogger(CertificateParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Certificate> parseCertificates(InputStream inputStream) {
        for (CertificateType type : CertificateType.values()) {
            try {
                List<Certificate> certificates = this.parseCertificates(type, inputStream);
                if (certificates.size() == 0) continue;
                List<Certificate> list = certificates;
                return list;
            }
            catch (Exception exc) {
                logger.debug("Cannot parse certificate of type %s: %s", new Object[]{type.name(), exc.getMessage()});
            }
            finally {
                try {
                    inputStream.reset();
                }
                catch (IOException exc) {}
            }
        }
        return new ArrayList<Certificate>();
    }

    public List<Certificate> parseCertificates(CertificateType type, InputStream inputStream) throws IOException, CertificateException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        if (type == CertificateType.PEM) {
            this.parseCertificatesPEM(certificates, inputStream);
        } else if (type == CertificateType.DER) {
            this.parseCertificatesDER(certificates, inputStream);
        }
        return certificates;
    }

    private void parseCertificatesDER(List<Certificate> certificates, InputStream inputStream) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        certificates.add(factory.generateCertificate(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCertificatesPEM(List<Certificate> certificates, InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        PEMReader pemReader = null;
        try {
            pemReader = new PEMReader((Reader)reader);
            while (pemReader.ready()) {
                Object obj = pemReader.readObject();
                if (!(obj instanceof Certificate)) continue;
                certificates.add((Certificate)obj);
            }
        }
        finally {
            StreamUtils.close((Reader)reader);
            StreamUtils.close((Reader)pemReader);
        }
    }

    public static enum CertificateType {
        PEM,
        DER;

    }
}

