/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.certificate.CertificateProperties;
import at.mrdevelopment.esl.certificate.CertificateWriter;
import at.mrdevelopment.esl.certificate.DuplicateCertificateException;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public abstract class AbstractStore {
    static ESLLogger logger;
    private static final int KEYLENGTH = 2048;
    protected final String storeFileProperty;
    protected final String storePasswordProperty;
    protected final KeyStore keyStore;
    protected final String hostname;
    private final boolean readOnly;
    private File keyStoreFile;
    private final CertificateWriter certificateWriter;

    public AbstractStore(String storeFileProperty, String storePasswordProperty, boolean readOnly) throws InitializationException {
        this(storeFileProperty, storePasswordProperty, AbstractStore.getHostName(), readOnly);
    }

    public AbstractStore(String storeFileProperty, String storePasswordProperty, String hostname, boolean readOnly) throws InitializationException {
        this.storeFileProperty = storeFileProperty;
        this.storePasswordProperty = storePasswordProperty;
        this.hostname = hostname;
        this.readOnly = readOnly;
        this.certificateWriter = new CertificateWriter();
        try {
            this.keyStore = this.loadKeyStore(storeFileProperty, storePasswordProperty);
            this.save();
        }
        catch (InvalidKeyException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (KeyStoreException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (NoSuchAlgorithmException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (CertificateException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (SecurityException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (SignatureException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IOException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String storeFileProperty, String storePasswordProperty) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, InvalidKeyException, SecurityException, SignatureException, InitializationException {
        this.keyStoreFile = new File(System.getProperty(storeFileProperty));
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream inputStream = null;
        try {
            inputStream = this.keyStoreFile.exists() ? new FileInputStream(this.keyStoreFile) : null;
            keyStore.load(inputStream, System.getProperty(storePasswordProperty).toCharArray());
            if (!this.keyStoreFile.exists()) {
                boolean created = this.createKeyStore(keyStore);
                if (!created) {
                    throw new InitializationException("Key store %s not found", new Object[]{storeFileProperty});
                }
                logger.info("Store created at: " + System.getProperty(storeFileProperty));
            }
        }
        catch (Throwable throwable) {
            StreamUtils.close(inputStream);
            throw throwable;
        }
        StreamUtils.close((InputStream)inputStream);
        return keyStore;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    protected abstract boolean createKeyStore(KeyStore var1) throws KeyStoreException, InvalidKeyException, NoSuchAlgorithmException, SecurityException, SignatureException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void save() {
        if (this.keyStore != null && !this.readOnly) {
            FileOutputStream output = null;
            try {
                File storeFile = new File(System.getProperty(this.storeFileProperty));
                if (!storeFile.exists() && storeFile.getParentFile() != null && !storeFile.getParentFile().exists()) {
                    storeFile.getParentFile().mkdirs();
                }
                output = new FileOutputStream(storeFile);
                this.keyStore.store(output, System.getProperty(this.storePasswordProperty).toCharArray());
            }
            catch (Exception exc) {
                try {
                    logger.error("Could not save key store: %s", new Object[]{exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(output);
                    throw throwable;
                }
                StreamUtils.close((OutputStream)output);
            }
            StreamUtils.close((OutputStream)output);
        }
    }

    protected String writePEM(Object object) throws IOException {
        return this.certificateWriter.writePEM(object);
    }

    protected String writePEM(Object[] objects) throws IOException {
        return this.certificateWriter.writePEM(objects);
    }

    protected void generateAndStoreKeyPair(KeyStore keyStore, String alias) throws NoSuchAlgorithmException, KeyStoreException, InvalidKeyException, SecurityException, SignatureException {
        KeyPairGenerator keyGenenrator = KeyPairGenerator.getInstance("RSA");
        keyGenenrator.initialize(2048);
        KeyPair keyPair = keyGenenrator.genKeyPair();
        keyStore.setKeyEntry(alias, keyPair.getPrivate(), System.getProperty(this.storePasswordProperty).toCharArray(), new Certificate[]{this.createSelfSignedCertificate(this.getDefaultProperties(), keyPair)});
        this.save();
    }

    public CertificateProperties getDefaultProperties() {
        return new CertificateProperties("AT", this.hostname, "SES-imagotag GmbH", "None", "Graz", "Styria", 10);
    }

    protected Certificate createSelfSignedCertificate(CertificateProperties properties, KeyPair keyPair) throws InvalidKeyException, SecurityException, SignatureException {
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        v3CertGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        v3CertGen.setIssuerDN((X509Name)new X509Principal(properties.toString()));
        Calendar notBefore = Calendar.getInstance();
        notBefore.set(14, 0);
        Calendar notAfter = Calendar.getInstance();
        notAfter.setTime(notBefore.getTime());
        notAfter.add(1, properties.getValidYears());
        v3CertGen.setNotBefore(notBefore.getTime());
        v3CertGen.setNotAfter(notAfter.getTime());
        v3CertGen.setSubjectDN((X509Name)new X509Principal(properties.toString()));
        v3CertGen.setPublicKey(keyPair.getPublic());
        v3CertGen.setSignatureAlgorithm("SHA512WithRSAEncryption");
        X509Certificate certificate = v3CertGen.generateX509Certificate(keyPair.getPrivate());
        return certificate;
    }

    protected static String getHostName() {
        try {
            return new EnvironmentProperties(true).getHostName();
        }
        catch (InitializationException exc) {
            logger.warn("Could not resolve hostname: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
            return "localhost";
        }
    }

    public void importCertificate(String alias, Certificate certificate) throws KeyStoreException, DuplicateCertificateException {
        this.keyStore.setCertificateEntry(alias, certificate);
        this.save();
    }

    public Map<String, X509Certificate> getTrustedCertificates() {
        HashMap<String, X509Certificate> certificateEntries = new HashMap<String, X509Certificate>();
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate[] entry;
                String alias = aliases.nextElement();
                if (this.keyStore.isCertificateEntry(alias)) {
                    entry = this.keyStore.getCertificate(alias);
                    if (!(entry instanceof X509Certificate)) continue;
                    certificateEntries.put(alias, (X509Certificate)entry);
                    continue;
                }
                if (!this.keyStore.isKeyEntry(alias) || (entry = this.keyStore.getCertificateChain(alias)) == null || entry.length <= 0 || !(entry[0] instanceof X509Certificate)) continue;
                certificateEntries.put(alias, (X509Certificate)entry[0]);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return certificateEntries;
    }

    public void deleteCertificate(String alias) throws KeyStoreException {
        if (this.getTrustedCertificates().containsKey(alias)) {
            this.keyStore.deleteEntry(alias);
            this.save();
        }
    }

    public boolean isCertificateSelfSigned(X509Certificate certificate) {
        return certificate.getIssuerX500Principal().equals(certificate.getSubjectX500Principal());
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        logger = ESLLogger.getLogger(AbstractStore.class);
    }
}

