/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.upload;

import at.mrdevelopment.esl.admin.platform.config.control.DefaultApplianceBackendControl;
import at.mrdevelopment.esl.admin.platform.upload.SoftwareUploadExecutor;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class KeystoreFileUploadExecutor
implements SoftwareUploadExecutor {
    static ESLLogger logger = ESLLogger.getLogger(KeystoreFileUploadExecutor.class);
    protected static String[] DEFAULT_EXTENSIONS = new String[]{"jks", "keystore"};
    private final DefaultApplianceBackendControl backendControl;

    public KeystoreFileUploadExecutor(DefaultApplianceBackendControl backendControl) {
        this.backendControl = backendControl;
    }

    @Override
    public void processUploadedFile(File file) throws Exception {
        this.validate(file);
        this.processValidatedFile(file);
    }

    protected void processValidatedFile(File file) throws Exception {
        this.backendControl.initKeyStoreUpdate(file.getAbsolutePath());
    }

    private void validate(File file) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("Keystore upload failed.");
        }
        if (!FilenameUtils.isExtension((String)file.getName(), (String[])DEFAULT_EXTENSIONS)) {
            FileUtils.deleteQuietly((File)file);
            throw new IOException("Keystore upload failed (invalid file extension).");
        }
    }
}

