/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.upload;

import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.upload.SoftwareUploadExecutor;
import at.mrdevelopment.esl.update.UpdatePackageMismatchException;
import at.mrdevelopment.esl.update.UpdatePackageValidator;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class DefaultSoftwareUploadExecutor
implements SoftwareUploadExecutor {
    static ESLLogger logger = ESLLogger.getLogger(DefaultSoftwareUploadExecutor.class);
    protected static String DEFAULT_EXTENSION = "tgz";
    private final BackendControl backendControl;
    private final SystemAttributes systemAttributes;
    private final String[] extensions;
    private final UpdatePackageValidator validator;

    public DefaultSoftwareUploadExecutor(BackendControl backendControl, SystemAttributes systemAttributes) throws InitializationException {
        this(backendControl, systemAttributes, DEFAULT_EXTENSION);
    }

    protected DefaultSoftwareUploadExecutor(BackendControl backendControl, SystemAttributes systemAttributes, String ... extensions) throws InitializationException {
        this.backendControl = backendControl;
        this.systemAttributes = systemAttributes;
        this.extensions = extensions;
        this.validator = new UpdatePackageValidator();
    }

    @Override
    public void processUploadedFile(File file) throws Exception {
        this.validate(file);
        this.processValidatedFile(file);
    }

    protected void processValidatedFile(File file) throws Exception {
        this.getBackendControl().initSoftwareUpdateAndReboot(file.getName());
    }

    private void validate(File file) throws IOException, UpdatePackageMismatchException {
        if (file == null || !file.exists()) {
            throw new IOException("Software upload failed.");
        }
        if (!FilenameUtils.isExtension((String)file.getName(), (String[])this.extensions)) {
            FileUtils.deleteQuietly((File)file);
            throw new IOException("Software upload failed (invalid file extension).");
        }
        try {
            this.validator.validatePackage(file, this.systemAttributes.getDeviceMode());
        }
        catch (IOException exc) {
            FileUtils.deleteQuietly((File)file);
            throw exc;
        }
        catch (UpdatePackageMismatchException exc) {
            FileUtils.deleteQuietly((File)file);
            throw exc;
        }
    }

    protected BackendControl getBackendControl() {
        return this.backendControl;
    }
}

