/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.upload;

import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.upload.SoftwareUploadExecutor;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ConfigurationFileUploadExecutor
implements SoftwareUploadExecutor {
    static ESLLogger logger = ESLLogger.getLogger(ConfigurationFileUploadExecutor.class);
    protected static String DEFAULT_EXTENSION = "config";
    private final BackendControl backendControl;

    public ConfigurationFileUploadExecutor(BackendControl backendControl) {
        this.backendControl = backendControl;
    }

    @Override
    public void processUploadedFile(File file) throws Exception {
        this.validate(file);
        this.processValidatedFile(file);
    }

    protected void processValidatedFile(File file) throws Exception {
        this.getBackendControl().initConfigurationUpdate(file.getName());
    }

    private void validate(File file) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("Configuration upload failed.");
        }
        if (!FilenameUtils.isExtension((String)file.getName(), (String)DEFAULT_EXTENSION)) {
            FileUtils.deleteQuietly((File)file);
            throw new IOException("Configuration upload failed (invalid file extension).");
        }
    }

    protected BackendControl getBackendControl() {
        return this.backendControl;
    }
}

