/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.upload;

import at.mrdevelopment.esl.admin.platform.config.control.AccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.upload.SoftwareUploadExecutor;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class AccessPointSoftwareUploadExecutor
implements SoftwareUploadExecutor {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointSoftwareUploadExecutor.class);
    private static final String FIRMWARE_EXTENSION = "xml";
    private final AccessPointBackendControl backendControl;

    public AccessPointSoftwareUploadExecutor(AccessPointBackendControl backendControl) {
        this.backendControl = backendControl;
    }

    protected void processValidatedFile(File file) throws Exception {
        if (FilenameUtils.isExtension((String)file.getName(), (String)FIRMWARE_EXTENSION)) {
            logger.info("Executing firmware update");
            AccessPointBackendControl backendControl = (AccessPointBackendControl)this.getBackendControl();
            backendControl.initFirmwareUpdate(file.getName());
        }
    }

    protected BackendControl getBackendControl() {
        return this.backendControl;
    }

    @Override
    public void processUploadedFile(File file) throws Exception {
        this.validate(file);
        this.processValidatedFile(file);
    }

    private void validate(File file) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("Firmware upload failed.");
        }
        if (!FilenameUtils.isExtension((String)file.getName(), (String)FIRMWARE_EXTENSION)) {
            FileUtils.deleteQuietly((File)file);
            throw new IOException("Firmware upload failed (invalid file extension).");
        }
    }
}

