/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.vpn;

import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.appliance.VPNWatcher;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;

public class VPNStatusEvaluator {
    static ESLLogger logger = ESLLogger.getLogger(VPNStatusEvaluator.class);
    private static final String PROVISIONING_HOST = "https://provisioning.ses-imagotag.com/api/v1/status";
    private static final String HOSTS_FILE = "/config/connectivity-hosts";
    private final ClientVPNConfiguration clientVPNConfiguration;
    private List<String> hosts;
    protected final boolean vpnConfigured;
    protected final boolean vpnUp;
    protected final boolean provisioningReachable;
    protected final boolean internetUp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VPNStatusEvaluator(ClientVPNConfiguration clientVPNConfiguration) {
        this.clientVPNConfiguration = clientVPNConfiguration;
        InputStream hostsFileStream = this.getClass().getResourceAsStream(HOSTS_FILE);
        ByteArrayOutputStream hosts = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)hostsFileStream, (OutputStream)hosts);
            this.hosts = this.getHosts(hosts.toString());
        }
        catch (IOException exception) {
            logger.warn(exception.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exception);
        }
        finally {
            StreamUtils.close((InputStream)hostsFileStream);
        }
        this.internetUp = this.hosts != null ? this.isInternetUp() : false;
        this.vpnConfigured = this.isVpnConfigured();
        this.vpnUp = this.vpnConfigured ? this.isVpnUp() : false;
        this.provisioningReachable = this.isProvisioningReachable();
    }

    public boolean isVpnUp() {
        try {
            return VPNWatcher.isRunning();
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exception);
            return false;
        }
    }

    public boolean isProvisioningReachable() {
        try {
            return this.isReachable(PROVISIONING_HOST);
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            logger.logExceptionIfDebugEnabled((Throwable)exception);
            return false;
        }
    }

    public boolean isInternetUp() {
        for (String host : this.hosts) {
            try {
                if (!this.isPingable(host)) continue;
                return true;
            }
            catch (Exception exception) {
                logger.warn(exception.getMessage());
                logger.logExceptionIfDebugEnabled((Throwable)exception);
            }
        }
        return false;
    }

    public boolean isVpnConfigured() {
        return this.clientVPNConfiguration != null && !this.clientVPNConfiguration.isDefaultConfiguration();
    }

    public boolean isVpnEnabled() {
        return this.clientVPNConfiguration != null && this.clientVPNConfiguration.isEnabled();
    }

    private List<String> getHosts(String hostString) {
        if (hostString != null) {
            ArrayList<String> hosts = new ArrayList<String>();
            for (String line : hostString.split("\n")) {
                hosts.add(line.split(" ")[0].split("#")[0].split("//")[0]);
            }
            return hosts;
        }
        return null;
    }

    private boolean isPingable(String host) throws IOException, InterruptedException {
        String option = SystemUtils.IS_OS_LINUX ? "-c 1" : "-n 1";
        Process process = Runtime.getRuntime().exec(String.format("ping %s %s", option, host));
        int returnVal = process.waitFor();
        return returnVal == 0;
    }

    private boolean isReachable(String host) throws IOException, InterruptedException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        HttpGet httpGet;
        TrustStrategy acceptAllTrustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        };
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptAllTrustStrategy).build();
        CloseableHttpClient client = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).useSystemProperties().build();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(httpGet = new HttpGet(host)));
        return response.getStatusLine().getStatusCode() == 200;
    }

    public ClientVPNConfiguration getClientVPNConfiguration() {
        return this.clientVPNConfiguration;
    }
}

