/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.vpn;

import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;

public class ClientVPNIptablesConfiguration
extends ClientVPNConfiguration {
    private final String preroutingDestination;

    public ClientVPNIptablesConfiguration(boolean enabled, String device, String protocol, String remoteAddress, String remotePort, String ca, String caChecksum, String cert, String certChecksum, String key, String keyChecksum, String logLevel, Collection<String> additionalOptions, String preroutingDestination) {
        super(enabled, device, protocol, remoteAddress, remotePort, ca, caChecksum, cert, certChecksum, key, keyChecksum, logLevel, additionalOptions);
        this.preroutingDestination = preroutingDestination;
    }

    public static ClientVPNConfiguration fromProperties(Properties properties, String ca, String caChecksum, String cert, String certChecksum, String key, String keyChecksum) {
        String enabled = properties.getProperty("vpn.enabled");
        String device = properties.getProperty("vpn.dev");
        String protocol = properties.getProperty("vpn.proto");
        String remoteAddress = properties.getProperty("vpn.remoteaddress");
        String remotePort = properties.getProperty("vpn.remoteport");
        String logLevel = properties.getProperty("vpn.verb");
        String additionalOptions = properties.getProperty("vpn.additionaloptions");
        String preroutingdestination = properties.getProperty("vpn.preroutingdestination");
        if (preroutingdestination == null) {
            return new ClientVPNConfiguration(Boolean.parseBoolean(enabled), device, protocol, remoteAddress, remotePort, "/esl/data/openvpn/keys/" + ca, caChecksum, "/esl/data/openvpn/keys/" + cert, certChecksum, "/esl/data/openvpn/keys/" + key, keyChecksum, logLevel, additionalOptions != null ? Arrays.asList(additionalOptions.split(";")) : null);
        }
        return new ClientVPNIptablesConfiguration(Boolean.parseBoolean(enabled), device, protocol, remoteAddress, remotePort, "/esl/data/openvpn/keys/" + ca, caChecksum, "/esl/data/openvpn/keys/" + cert, certChecksum, "/esl/data/openvpn/keys/" + key, keyChecksum, logLevel, additionalOptions != null ? Arrays.asList(additionalOptions.split(";")) : null, preroutingdestination);
    }

    public String getPreroutingDestination() {
        return this.preroutingDestination;
    }
}

