/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.vpn;

import at.mrdevelopment.esl.admin.platform.config.vpn.VPNConfiguration;
import java.util.Collection;
import java.util.Collections;

public class ClientVPNConfiguration
extends VPNConfiguration {
    protected static final String DEFAULT_DEVICE = "tun";
    protected static final String DEFAULT_PROTOCOL = "udp";
    protected static final String DEFAULT_ADDRESS = "localhost";
    protected static final String DEFAULT_PORT = "1194";
    protected static final String DEFAULT_KEYS = "/esl/data/openvpn/keys/";
    protected static final String DEFAULT_CA = "/esl/data/openvpn/keys/ca.crt";
    protected static final String DEFAULT_CERT = "/esl/data/openvpn/keys/ses-imagotag.crt";
    protected static final String DEFAULT_KEY = "/esl/data/openvpn/keys/ses-imagotag.key";
    protected static final String DEFAULT_LOG_LEVEL = "3";
    protected static final Collection<String> DEFAULT_ADDITIONAL_OPTIONS = Collections.emptyList();
    private final String connectionType;

    public ClientVPNConfiguration() {
        super(false, DEFAULT_DEVICE, DEFAULT_PROTOCOL, DEFAULT_ADDRESS, DEFAULT_PORT, DEFAULT_CA, DEFAULT_CERT, DEFAULT_KEY, DEFAULT_LOG_LEVEL);
        this.connectionType = "client";
        this.additionalOptions = DEFAULT_ADDITIONAL_OPTIONS;
    }

    public ClientVPNConfiguration(boolean enabled, String device, String protocol, String remoteAddress, String remotePort, String ca, String caChecksum, String cert, String certChecksum, String key, String keyChecksum, String logLevel, Collection<String> additionalOptions) {
        super(enabled, device, protocol, remoteAddress, remotePort, ca, caChecksum, cert, certChecksum, key, keyChecksum, logLevel);
        this.connectionType = "client";
        if (additionalOptions != null) {
            this.additionalOptions = additionalOptions;
        }
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public boolean isDefaultConfiguration() {
        return !this.enabled && this.device.equals(DEFAULT_DEVICE) && this.protocol.equals(DEFAULT_PROTOCOL) && this.remoteAddress.equals(DEFAULT_ADDRESS) && this.remotePort.equals(DEFAULT_PORT) && this.ca.equals(DEFAULT_CA) && this.cert.equals(DEFAULT_CERT) && this.key.equals(DEFAULT_KEY) && this.logLevel.equals(DEFAULT_LOG_LEVEL) && this.connectionType.equals("client") && ((Object)this.additionalOptions).equals(DEFAULT_ADDITIONAL_OPTIONS);
    }
}

