/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.storage;

import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ProvisioningTokenStorage {
    static ESLLogger logger = ESLLogger.getLogger(ProvisioningTokenStorage.class);
    private static final String PROVISIONING_TOKEN = "provisioning.token";
    private static final String PROVISIONING_FILE_REFERENCE = "provisioning.file";
    private static final String PROVISIONING_POST_ACTION_TASK_ID = "provisioning.post.id";
    private final PlatformStorage storage;

    public ProvisioningTokenStorage(PlatformStorage storage) {
        this.storage = storage;
    }

    public void saveProvisioningToken(String provisioningToken) throws SerializeException {
        this.storage.storeKey(PROVISIONING_TOKEN, provisioningToken);
    }

    public String loadProvisioningToken() throws SerializeException {
        return this.storage.queryKey(PROVISIONING_TOKEN);
    }

    public void resetProvisioningToken() throws SerializeException {
        this.storage.storeKey(PROVISIONING_TOKEN, "");
    }

    public boolean saveFileReference(String prefix, String fileName, String fileHash) throws SerializeException {
        return this.saveFileReference(prefix, fileName, fileHash, true);
    }

    public List<String> removeFileReferencesNotInList(String prefix, Collection<String> fileNames) throws SerializeException {
        ArrayList<String> filesToRemove = new ArrayList<String>();
        ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
        ArrayList<String> existingFileNames = new ArrayList<String>(Arrays.asList(this.loadFileNames(prefix)));
        ArrayList<String> existingFileHashes = new ArrayList<String>(Arrays.asList(this.loadFileHashes(prefix)));
        for (int index = 0; index < existingFileNames.size(); ++index) {
            String existingFileName = (String)existingFileNames.get(index);
            if (fileNames.contains(existingFileName)) continue;
            filesToRemove.add(existingFileName);
            indicesToRemove.add(index);
        }
        for (Integer index : Lists.reverse(indicesToRemove)) {
            existingFileNames.remove(index);
            existingFileHashes.remove(index);
        }
        String fileNamesString = Joiner.on((String)";").join(existingFileNames);
        String fileHashesString = Joiner.on((String)";").join(existingFileHashes);
        this.storage.storeKey(String.format("%s.%s.names", PROVISIONING_FILE_REFERENCE, prefix), fileNamesString);
        this.storage.storeKey(String.format("%s.%s.hashes", PROVISIONING_FILE_REFERENCE, prefix), fileHashesString);
        return filesToRemove;
    }

    private String[] loadFileNames(String prefix) throws SerializeException {
        String fileNamesString = this.storage.queryKey(String.format("%s.%s.names", PROVISIONING_FILE_REFERENCE, prefix));
        String[] fileNames = new String[]{};
        if (fileNamesString != null && !fileNamesString.isEmpty()) {
            fileNames = StringUtils.split((String)fileNamesString, (String)";");
        }
        return fileNames;
    }

    private String[] loadFileHashes(String prefix) throws SerializeException {
        String fileHashesString = this.storage.queryKey(String.format("%s.%s.hashes", PROVISIONING_FILE_REFERENCE, prefix));
        String[] fileHashes = new String[]{};
        if (fileHashesString != null && !fileHashesString.isEmpty()) {
            fileHashes = StringUtils.split((String)fileHashesString, (String)";");
        }
        return fileHashes;
    }

    private boolean saveFileReference(String prefix, String fileName, String fileHash, boolean save) throws SerializeException {
        boolean updated = false;
        boolean found = false;
        Object[] fileNames = this.loadFileNames(prefix);
        Object[] fileHashes = this.loadFileHashes(prefix);
        for (int index = 0; index < fileNames.length; ++index) {
            String currentFileName = fileNames[index];
            String currentFileHash = fileHashes[index];
            if (!currentFileName.equals(fileName)) continue;
            found = true;
            if (currentFileHash.equals(fileHash)) continue;
            updated = true;
            fileHashes[index] = fileHash;
        }
        if (found && !updated) {
            return false;
        }
        if (!found) {
            fileNames = (String[])ArrayUtils.add((Object[])fileNames, (Object)fileName);
            fileHashes = (String[])ArrayUtils.add((Object[])fileHashes, (Object)fileHash);
        }
        if (save) {
            String fileNamesString = Joiner.on((String)";").join(fileNames);
            String fileHashesString = Joiner.on((String)";").join(fileHashes);
            this.storage.storeKey(String.format("%s.%s.names", PROVISIONING_FILE_REFERENCE, prefix), fileNamesString);
            this.storage.storeKey(String.format("%s.%s.hashes", PROVISIONING_FILE_REFERENCE, prefix), fileHashesString);
        }
        return true;
    }

    public boolean checkFileReference(String prefix, String fileName, String fileHash) throws SerializeException {
        return this.saveFileReference(prefix, fileName, fileHash, false);
    }

    public void clear() throws SerializeException {
        this.storage.clearProvisioningEntries();
    }

    public void clearVPNFiles() throws SerializeException {
        this.storage.clearProvisioningVPNFiles();
    }

    public void saveForPostUpdateAction(long postActionTaskId) throws SerializeException {
        this.storage.storeKey(PROVISIONING_POST_ACTION_TASK_ID, String.valueOf(postActionTaskId));
    }

    public Long loadTaskToWatch() throws SerializeException {
        String idString = this.storage.queryKey(PROVISIONING_POST_ACTION_TASK_ID);
        if (idString != null && !idString.isEmpty()) {
            return Long.valueOf(idString);
        }
        return null;
    }

    public void clearPostUpdateAction() throws SerializeException {
        this.storage.storeKey(PROVISIONING_POST_ACTION_TASK_ID, "");
    }
}

