/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.storage;

import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.toolkit.xml.SerializeException;
import joptsimple.internal.Strings;

public class ProvisioningConfigurationStorage {
    private static final String PROVISIONING_RELOAD_INTERVAL = "provisioning.config.interval";
    private static final String PROVISIONING_API_VERSION = "provisioning.config.version";
    private static final String PROVISIONING_AUTHORIZATION_URL = "provisioning.config.auth.url";
    private static final String PROVISIONING_SSL_VERIFICATION = "provisioning.config.ssl.verification";
    private static final String PROVISIONING_SSL_HOSTNAME_VERIFICATION = "provisioning.config.ssl.hostname.verification";
    private static final String DEFAULT_RELOAD_INTERVAL = String.valueOf(30);
    private static final String DEFAULT_API_VERSION = "1";
    private static final String DEFAULT_AUTHORIZATION_URL = "https://provisioning-auth-dev.ses-imagotag.com";
    private static final boolean DEFAULT_SSL_VERIFICATION = true;
    private static final boolean DEFAULT_SSL_HOSTNAME_VERIFICATION = true;
    private final PlatformStorage storage;

    public ProvisioningConfigurationStorage(PlatformStorage storage) {
        this.storage = storage;
    }

    public String loadReloadInterval() throws SerializeException {
        String reloadInterval = this.load(PROVISIONING_RELOAD_INTERVAL, String.class);
        return Strings.isNullOrEmpty((String)reloadInterval) ? DEFAULT_RELOAD_INTERVAL : reloadInterval;
    }

    public void saveReloadInterval(String reloadInterval) throws SerializeException {
        this.save(PROVISIONING_RELOAD_INTERVAL, reloadInterval);
    }

    public String loadAPIVersion() throws SerializeException {
        String apiVersion = this.load(PROVISIONING_API_VERSION, String.class);
        return Strings.isNullOrEmpty((String)apiVersion) ? DEFAULT_API_VERSION : apiVersion;
    }

    public void saveAPIVersion(String apiVersion) throws SerializeException {
        this.save(PROVISIONING_API_VERSION, apiVersion);
    }

    public String loadAuthorizationURL() throws SerializeException {
        String authUrl = this.load(PROVISIONING_AUTHORIZATION_URL, String.class);
        return Strings.isNullOrEmpty((String)authUrl) ? DEFAULT_AUTHORIZATION_URL : authUrl;
    }

    public void saveAuthorizationURL(String authorizationUrl) throws SerializeException {
        this.save(PROVISIONING_AUTHORIZATION_URL, authorizationUrl);
    }

    public boolean loadSSLVerification() throws SerializeException {
        Boolean sslVerfiy = this.load(PROVISIONING_SSL_VERIFICATION, Boolean.class);
        return sslVerfiy == null ? true : sslVerfiy;
    }

    public void saveSSLVerification(Boolean sslVerification) throws SerializeException {
        this.save(PROVISIONING_SSL_VERIFICATION, sslVerification);
    }

    public Boolean loadSSLHostnameVerification() throws SerializeException {
        Boolean hostnameVerify = this.load(PROVISIONING_SSL_HOSTNAME_VERIFICATION, Boolean.class);
        return hostnameVerify == null ? true : hostnameVerify;
    }

    public void saveSSLHostnameVerification(Boolean sslHostnameVerification) throws SerializeException {
        this.save(PROVISIONING_SSL_HOSTNAME_VERIFICATION, sslHostnameVerification);
    }

    protected void save(String key, Object value) throws SerializeException {
        this.storage.storeKey(key, value != null ? value.toString() : null);
    }

    protected <T> T load(String key, Class<T> type) throws SerializeException {
        String value = this.storage.queryKey(key);
        if (value == null) {
            return null;
        }
        try {
            if (type == String.class) {
                return type.cast(value);
            }
            if (type == Boolean.class) {
                return type.cast(Boolean.valueOf(value));
            }
            if (type == Integer.class) {
                return type.cast(Integer.parseInt(value));
            }
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc, "Failed to parse storage key %s", new Object[]{key});
        }
        throw new SerializeException("Unsupported storage type %s for key %s", new Object[]{type.getName(), key});
    }
}

