/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.storage;

import at.mrdevelopment.esl.admin.AccessPointConfigurationXMLSerializer;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.storage.ConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.http.XMLContentProducerFactory;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.entity.ContentProducer;
import org.w3c.dom.Document;

public class FileStoredConfigurationStorage
implements ConfigurationStorage<AccessPointConfiguration> {
    private final XMLContentProducerFactory contentProducerFactory;
    private final AccessPointConfigurationXMLSerializer xmlAccessPointConfiguration;
    public static final File CONFIG_DIRECTORY = new File("/etc/esl");
    public static final File CONFIG_FILE = new File(FilenameUtils.concat((String)CONFIG_DIRECTORY.getPath(), (String)"configuration.xml"));
    private final ThinAPConfiguration thinAPConfiguration;

    public FileStoredConfigurationStorage(ThinAPConfiguration thinAPConfiguration) throws InitializationException {
        this.checkDirectory(CONFIG_DIRECTORY);
        this.thinAPConfiguration = thinAPConfiguration;
        this.contentProducerFactory = XMLContentProducerFactory.newInstance();
        this.xmlAccessPointConfiguration = new AccessPointConfigurationXMLSerializer();
    }

    @Override
    public void initialize(AccessPointConfiguration initialConfiguration) throws SerializeException {
        if (!CONFIG_FILE.exists()) {
            this.saveConfiguration(initialConfiguration);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void saveConfiguration(AccessPointConfiguration newConfiguration) throws SerializeException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(CONFIG_FILE);
            Document document = this.xmlAccessPointConfiguration.toXML(newConfiguration);
            ContentProducer contentProducer = this.contentProducerFactory.createContentProducer(document);
            contentProducer.writeTo((OutputStream)outputStream);
        }
        catch (FileNotFoundException exc) {
            try {
                throw new SerializeException("Missing access point configuration", new Object[0]);
                catch (Exception exc2) {
                    throw new SerializeException("Failed to save access point configuration", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(outputStream);
                throw throwable;
            }
        }
        StreamUtils.close((OutputStream)outputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized AccessPointConfiguration loadConfiguration() throws SerializeException {
        AccessPointConfiguration accessPointConfiguration;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(CONFIG_FILE);
            accessPointConfiguration = this.xmlAccessPointConfiguration.parseXML(inputStream, this.thinAPConfiguration);
        }
        catch (FileNotFoundException exc) {
            try {
                throw new SerializeException("Missing access point configuration", new Object[0]);
                catch (Exception exc2) {
                    throw new SerializeException("Failed to load access point configuration", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close((InputStream)inputStream);
        return accessPointConfiguration;
    }

    private void checkDirectory(File directory) throws InitializationException {
        if (!directory.exists()) {
            throw new InitializationException("'%s' does not exist", new Object[]{directory.getAbsolutePath()});
        }
        if (!directory.isDirectory()) {
            throw new InitializationException("'%s' is not a directory", new Object[]{directory.getAbsolutePath()});
        }
        if (!directory.canWrite()) {
            throw new InitializationException("'%s' is not writable", new Object[]{directory.getAbsolutePath()});
        }
    }

    @Override
    public AccessPointConfiguration newDefaultConfiguration(AccessPointConfiguration oldDefaultConfiguration, SystemAttributes systemAttributes) throws SerializeException {
        return AccessPointConfiguration.newDefaultConfiguration(systemAttributes, oldDefaultConfiguration);
    }

    @Override
    public PlatformStorage getStorage() {
        return null;
    }
}

