/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.storage;

import at.mrdevelopment.esl.admin.platform.BackendTaskInfo;
import at.mrdevelopment.esl.admin.platform.BackendTaskStatus;
import at.mrdevelopment.esl.admin.platform.ProvisioningProblem;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.NotImplementedException;

public class FilePlatformStorage
implements PlatformStorage {
    static ESLLogger logger = ESLLogger.getLogger(FilePlatformStorage.class);
    private final Properties properties = new Properties();

    public FilePlatformStorage() {
    }

    public FilePlatformStorage(Map<String, String> configuration) {
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            if (entry.getValue() == null) continue;
            this.properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public long insertTask(BackendTaskInfo taskInfo) throws SerializeException {
        throw new NotImplementedException("insertTask");
    }

    @Override
    public BackendTaskInfo queryNextTask() throws SerializeException {
        return null;
    }

    @Override
    public void closeTask(long id, BackendTaskStatus status) throws SerializeException {
    }

    @Override
    public List<BackendTaskInfo> queryTasks() throws SerializeException {
        return null;
    }

    @Override
    public BackendTaskInfo queryTask(long id) throws SerializeException {
        return null;
    }

    @Override
    public Map<String, String> queryConfiguration() throws SerializeException {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (String key : this.properties.stringPropertyNames()) {
            configuration.put(key, this.properties.getProperty(key));
        }
        return configuration;
    }

    @Override
    public void storeKey(String key, String value) throws SerializeException {
        this.properties.setProperty(key, value);
    }

    @Override
    public String queryKey(String key) throws SerializeException {
        return this.properties.getProperty(key);
    }

    @Override
    public void storeProvisioningProblem(String configurationId, String message) throws SerializeException {
    }

    @Override
    public void updateProvisioningProblems() throws SerializeException {
    }

    @Override
    public List<ProvisioningProblem> queryNewProvisioningProblems() throws SerializeException {
        return null;
    }

    @Override
    public void setInitializationMode(boolean initMode) {
        throw new NotImplementedException("setInitializationMode");
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.properties.load(inputStream);
        }
        catch (IOException exc) {
            try {
                logger.warn("Could not load from file %s: %s", new Object[]{file.getName(), exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close((InputStream)inputStream);
        }
        StreamUtils.close((InputStream)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            this.properties.store(outputStream, "");
        }
        catch (IOException exc) {
            try {
                logger.warn("Could not save to file %s: %s", new Object[]{file.getName(), exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(outputStream);
                throw throwable;
            }
            StreamUtils.close((OutputStream)outputStream);
        }
        StreamUtils.close((OutputStream)outputStream);
    }

    @Override
    public void clearProvisioningEntries() throws SerializeException {
    }

    @Override
    public void clearProvisioningVPNFiles() throws SerializeException {
    }
}

