/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.storage;

import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.admin.platform.config.GenericPlatformConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LogLevel;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ProtectionLevel;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.storage.ConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.UUID;

public abstract class DefaultConfigurationStorage<C extends GenericPlatformConfiguration>
implements ConfigurationStorage<C> {
    static ESLLogger logger = ESLLogger.getLogger(DefaultConfigurationStorage.class);
    protected static final String CONFIG_INITIALIZED = "config.initialized";
    protected static final String NETWORK_HOSTNAME = "network.hostname";
    protected static final String NETWORK_DHCP = "network.dhcp";
    protected static final String NETWORK_ADDRESS = "network.address";
    protected static final String NETWORK_NETMASK = "network.netmask";
    protected static final String NETWORK_GATEWAY = "network.gateway";
    protected static final String NETWORK_NAMESERVER1 = "network.nameserver1";
    protected static final String NETWORK_NAMESERVER2 = "network.nameserver2";
    private static final String TIMESYNC_ENABLED = "timesync.enabled";
    private static final String TIMESYNC_TIMESERVER = "timesync.timeserver";
    private static final String TIMESYNC_INTERVAL = "timesync.interval";
    private static final String LOGGING_LEVEL = "logging.level";
    private static final String LOGGING_ENABLED = "logging.enabled";
    private static final String LOGGING_HOST = "logging.host";
    private static final String LOGGING_PORT = "logging.port";
    private static final String WS_HTTP_PORT_ENABLED = "ws.port.http.enabled";
    private static final String WS_HTTPS_PORT_ENABLED = "ws.port.https.enabled";
    private static final String WS_DEFAULT_PORT_SSL = "ws.port.default.ssl";
    private static final String USE_DEFAULT_TRUSTSTORE = "truststore.default";
    protected static final String SSL_CLIENT_CERTIFICATE_VERIFICATION = "ssl.clientcert";
    private final PlatformStorage storage;

    public DefaultConfigurationStorage(PlatformStorage storage) throws SerializeException {
        this.storage = storage;
    }

    @Override
    public void initialize(C initialConfiguration) throws SerializeException {
        this.storage.setInitializationMode(true);
        this.saveConfiguration(initialConfiguration);
        this.storage.setInitializationMode(false);
    }

    protected void saveNetworkConfiguration(NetworkConfiguration networkConfiguration) throws SerializeException {
        this.save(NETWORK_HOSTNAME, networkConfiguration.getHostName());
        this.save(NETWORK_DHCP, networkConfiguration.isDhcp());
        this.save(NETWORK_ADDRESS, networkConfiguration.getAddress());
        this.save(NETWORK_NETMASK, networkConfiguration.getNetmask());
        this.save(NETWORK_GATEWAY, networkConfiguration.getGateway());
        this.save(NETWORK_NAMESERVER1, networkConfiguration.getNameServer1());
        this.save(NETWORK_NAMESERVER2, networkConfiguration.getNameServer2());
    }

    protected void saveTimesyncConfiguration(TimesyncConfiguration timesyncConfiguration) throws SerializeException {
        this.save(TIMESYNC_ENABLED, timesyncConfiguration.isEnabled());
        this.save(TIMESYNC_TIMESERVER, timesyncConfiguration.getTimeServer());
        this.save(TIMESYNC_INTERVAL, timesyncConfiguration.getUpdateInterval());
    }

    protected void saveLoggingConfiguration(LoggingConfiguration loggingConfiguration) throws SerializeException {
        this.save(LOGGING_LEVEL, (Object)loggingConfiguration.getLogLevel());
        this.save(LOGGING_ENABLED, loggingConfiguration.isSocketAppenderEnabled());
        this.save(LOGGING_HOST, loggingConfiguration.getSocketRemoteAddress());
        this.save(LOGGING_PORT, loggingConfiguration.getSocketAppenderPort());
    }

    protected void saveWebserviceConfiguration(WebserviceConfiguration webserviceConfiguration) throws SerializeException {
        this.save(WS_HTTP_PORT_ENABLED, webserviceConfiguration.isHttpPortEnabled());
        this.save(WS_HTTPS_PORT_ENABLED, webserviceConfiguration.isHttpsPortEnabled());
        this.save(WS_DEFAULT_PORT_SSL, (Object)webserviceConfiguration.getDefaultServiceState());
    }

    protected void saveTrustStoreConfiguration(TrustStoreConfiguration trustStoreConfiguration) throws SerializeException {
        this.save(USE_DEFAULT_TRUSTSTORE, trustStoreConfiguration.isUseDefaultTrustStore());
    }

    protected TrustStoreConfiguration loadTrustStoreConfiguration() throws SerializeException {
        Boolean useDefaultTrustStore = this.load(USE_DEFAULT_TRUSTSTORE, Boolean.class);
        TrustStoreConfiguration trustStoreConfiguration = null;
        trustStoreConfiguration = useDefaultTrustStore == null ? new TrustStoreConfiguration() : new TrustStoreConfiguration(useDefaultTrustStore);
        return trustStoreConfiguration;
    }

    @Override
    public abstract C loadConfiguration() throws SerializeException;

    protected void waitForInitialization() throws SerializeException {
        while (!this.isInitialized()) {
            logger.info("Waiting for configuration...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exc) {
                throw new SerializeException("Configuration not initialized", new Object[0]);
            }
        }
    }

    protected boolean isInitialized() throws SerializeException {
        Boolean initialized = this.load(CONFIG_INITIALIZED, Boolean.class);
        return initialized != null && initialized != false;
    }

    protected NetworkConfiguration loadNetworkConfiguration() throws SerializeException {
        String hostName = this.load(NETWORK_HOSTNAME, String.class);
        String gateway = this.load(NETWORK_GATEWAY, String.class);
        String nameServer1 = this.load(NETWORK_NAMESERVER1, String.class);
        String nameServer2 = this.load(NETWORK_NAMESERVER2, String.class);
        boolean dhcp = this.load(NETWORK_DHCP, Boolean.class);
        if (dhcp) {
            if (gateway != null && !gateway.isEmpty() || nameServer1 != null && !nameServer1.isEmpty() || nameServer2 != null && !nameServer2.isEmpty()) {
                return new NetworkConfiguration(hostName, gateway, nameServer1, nameServer2);
            }
            return new NetworkConfiguration(hostName);
        }
        String address = this.load(NETWORK_ADDRESS, String.class);
        String netmask = this.load(NETWORK_NETMASK, String.class);
        return new NetworkConfiguration(hostName, address, netmask, gateway, nameServer1, nameServer2);
    }

    protected TimesyncConfiguration loadTimesyncConfiguration() throws SerializeException {
        boolean enabled = this.load(TIMESYNC_ENABLED, Boolean.class);
        String timeServer = this.load(TIMESYNC_TIMESERVER, String.class);
        int updateIntervalInMinutes = this.load(TIMESYNC_INTERVAL, Integer.class);
        return new TimesyncConfiguration(enabled, timeServer, updateIntervalInMinutes);
    }

    protected LoggingConfiguration loadLoggingConfiguration() throws SerializeException {
        LogLevel logLevel = this.load(LOGGING_LEVEL, LogLevel.class);
        boolean enabled = this.load(LOGGING_ENABLED, Boolean.class);
        String host = this.load(LOGGING_HOST, String.class);
        int port = this.load(LOGGING_PORT, Integer.class);
        return new LoggingConfiguration(logLevel, port, host, enabled);
    }

    protected WebserviceConfiguration loadWebserviceConfiguration() throws SerializeException {
        Boolean httpPortEnabled = this.load(WS_HTTP_PORT_ENABLED, Boolean.class);
        httpPortEnabled = httpPortEnabled != null ? httpPortEnabled : true;
        Boolean httpsPortEnabled = this.load(WS_HTTPS_PORT_ENABLED, Boolean.class);
        httpsPortEnabled = httpsPortEnabled != null ? httpsPortEnabled : true;
        String defaultPortStateString = this.load(WS_DEFAULT_PORT_SSL, String.class);
        String string = defaultPortStateString = defaultPortStateString != null ? defaultPortStateString : WebserviceConfiguration.WebserviceState.ENABLED_NORMAL.toString();
        if (defaultPortStateString.toLowerCase().equals("true") || defaultPortStateString.toLowerCase().equals("false")) {
            defaultPortStateString = Boolean.valueOf(defaultPortStateString) != false ? WebserviceConfiguration.WebserviceState.ENABLED_SSL.toString() : WebserviceConfiguration.WebserviceState.ENABLED_NORMAL.toString();
        }
        return new WebserviceConfiguration(httpPortEnabled, httpsPortEnabled, WebserviceConfiguration.WebserviceState.valueOf(defaultPortStateString));
    }

    protected void save(String key, Object value) throws SerializeException {
        this.storage.storeKey(key, value != null ? value.toString() : null);
    }

    protected <T> T load(String key, Class<T> type) throws SerializeException {
        String value = this.storage.queryKey(key);
        if (value == null) {
            return null;
        }
        try {
            if (type == String.class) {
                return type.cast(value);
            }
            if (type == Boolean.class) {
                return type.cast(Boolean.valueOf(value));
            }
            if (type == Integer.class) {
                return type.cast(Integer.parseInt(value));
            }
            if (type == LogLevel.class) {
                return type.cast((Object)LogLevel.valueOf(value));
            }
            if (type == DeviceMode.class) {
                return type.cast((Object)DeviceMode.valueOf(value));
            }
            if (type == WirelessChannel.class) {
                if (value.isEmpty()) {
                    return null;
                }
                return type.cast((Object)WirelessChannel.getFromId(Integer.parseInt(value)));
            }
            if (type == UUID.class) {
                if (value.isEmpty()) {
                    return null;
                }
                return type.cast(UUID.fromString(value));
            }
            if (type == ProtectionLevel.class) {
                return type.cast((Object)ProtectionLevel.valueOf(value));
            }
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc, "Failed to parse storage key %s", new Object[]{key});
        }
        throw new SerializeException("Unsupported storage type %s for key %s", new Object[]{type.getName(), key});
    }

    @Override
    public PlatformStorage getStorage() {
        return this.storage;
    }
}

