/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.storage;

import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.ApplianceMiniConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ApplianceWebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LowFrequencyDriverConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ServiceLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.storage.AbstractApplianceConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class DefaultApplianceMiniConfigurationStorage
extends AbstractApplianceConfigurationStorage<ApplianceMiniConfiguration> {
    private static final String LF_CONFIG_ENABLED = "lf.enabled";

    public DefaultApplianceMiniConfigurationStorage(PlatformStorage storage) throws SerializeException {
        super(storage);
    }

    protected void saveLowFrequencyDriverConfiguration(LowFrequencyDriverConfiguration lowFrequencyDriverConfiguration) throws SerializeException {
        this.save(LF_CONFIG_ENABLED, lowFrequencyDriverConfiguration.isEnabled());
    }

    protected LowFrequencyDriverConfiguration loadLowFrequencyDriverConfiguration() throws SerializeException {
        boolean enabled = this.load(LF_CONFIG_ENABLED, Boolean.class);
        return new LowFrequencyDriverConfiguration(enabled);
    }

    @Override
    public ApplianceMiniConfiguration newDefaultConfiguration(ApplianceMiniConfiguration oldConfiguration, SystemAttributes systemAttributes) throws SerializeException {
        return ApplianceMiniConfiguration.newDefaultConfiguration(systemAttributes, oldConfiguration);
    }

    @Override
    public void saveConfiguration(ApplianceMiniConfiguration newConfiguration) throws SerializeException {
        this.saveNetworkConfiguration(newConfiguration.getNetworkConfiguration());
        this.saveLowFrequencyDriverConfiguration(newConfiguration.getLowFrequencyDriverConfiguration());
        this.saveTimesyncConfiguration(newConfiguration.getTimesyncConfiguration());
        this.saveLoggingConfiguration(newConfiguration.getLoggingConfiguration());
        this.saveApplianceWebserviceConfiguration(newConfiguration.getWebserviceConfiguration());
        this.saveServerLevelConfiguration(newConfiguration.getServiceLevelConfiguration());
        this.saveTrustStoreConfiguration(newConfiguration.getTrustStoreConfiguration());
        this.saveClientVPNConfiguration(newConfiguration.getClientVPNConfiguration());
        this.save("config.initialized", true);
    }

    @Override
    public ApplianceMiniConfiguration loadConfiguration() throws SerializeException {
        this.waitForInitialization();
        LowFrequencyDriverConfiguration lowFrequencyDriverConfiguration = this.loadLowFrequencyDriverConfiguration();
        NetworkConfiguration networkConfiguration = this.loadNetworkConfiguration();
        TimesyncConfiguration timesyncConfiguration = this.loadTimesyncConfiguration();
        LoggingConfiguration loggingConfiguration = this.loadLoggingConfiguration();
        ApplianceWebserviceConfiguration webserviceConfiguration = this.loadApplianceWebserviceConfiguration();
        ServiceLevelConfiguration serviceLevelConfiguration = this.loadServiceLevelConfiguration();
        TrustStoreConfiguration trustStoreConfiguration = this.loadTrustStoreConfiguration();
        ClientVPNConfiguration vpnConfiguration = this.loadClientVPNConfiguration();
        return new ApplianceMiniConfiguration(timesyncConfiguration, loggingConfiguration, webserviceConfiguration, networkConfiguration, lowFrequencyDriverConfiguration, serviceLevelConfiguration, trustStoreConfiguration, vpnConfiguration);
    }
}

