/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.storage;

import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.ApplianceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ApplianceWebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ServiceLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.BridgeNetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.MultiNetworkInterfaceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkInterfaceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkInterfaceConfigurationEntry;
import at.mrdevelopment.esl.admin.platform.config.storage.AbstractApplianceConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;

public class DefaultApplianceConfigurationStorage
extends AbstractApplianceConfigurationStorage<ApplianceConfiguration> {
    private static final String NETWORK_BRIDGE_ENABLED = "network.bridge.enabled";
    private static final String NETWORK_BRIDGE_DHCP = "network.bridge.dhcp";
    private static final String NETWORK_BRIDGE_ADDRESS = "network.bridge.address";
    private static final String NETWORK_BRIDGE_NETMASK = "network.bridge.netmask";
    private static final String NETWORK_INTERFACE_PREFIX = "network.interface.";
    private static final String NETWORK_INTERFACES = "network.interfaces";

    public DefaultApplianceConfigurationStorage(PlatformStorage storage) throws SerializeException {
        super(storage);
    }

    @Override
    public void saveConfiguration(ApplianceConfiguration newConfiguration) throws SerializeException {
        this.saveMultiNetworkConfiguration(newConfiguration.getNetworkConfiguration());
        this.saveTimesyncConfiguration(newConfiguration.getTimesyncConfiguration());
        this.saveLoggingConfiguration(newConfiguration.getLoggingConfiguration());
        this.saveApplianceWebserviceConfiguration(newConfiguration.getWebserviceConfiguration());
        this.saveServerLevelConfiguration(newConfiguration.getServiceLevelConfiguration());
        this.saveTrustStoreConfiguration(newConfiguration.getTrustStoreConfiguration());
        this.saveClientVPNConfiguration(newConfiguration.getClientVPNConfiguration());
        this.save("config.initialized", true);
    }

    @Override
    public ApplianceConfiguration loadConfiguration() throws SerializeException {
        this.waitForInitialization();
        MultiNetworkInterfaceConfiguration networkConfiguration = this.loadMultiNetworkConfiguration();
        TimesyncConfiguration timesyncConfiguration = this.loadTimesyncConfiguration();
        LoggingConfiguration loggingConfiguration = this.loadLoggingConfiguration();
        ApplianceWebserviceConfiguration webserviceConfiguration = this.loadApplianceWebserviceConfiguration();
        ServiceLevelConfiguration serviceLevelConfiguration = this.loadServiceLevelConfiguration();
        TrustStoreConfiguration trustStoreConfiguration = this.loadTrustStoreConfiguration();
        ClientVPNConfiguration vpnConfiguration = this.loadClientVPNConfiguration();
        return new ApplianceConfiguration(networkConfiguration, timesyncConfiguration, loggingConfiguration, webserviceConfiguration, serviceLevelConfiguration, trustStoreConfiguration, vpnConfiguration);
    }

    protected void saveMultiNetworkConfiguration(MultiNetworkInterfaceConfiguration networkConfiguration) throws SerializeException {
        this.save("network.hostname", networkConfiguration.getHostName());
        this.save("network.nameserver1", networkConfiguration.getNameServer1());
        this.save("network.nameserver2", networkConfiguration.getNameServer2());
        this.save("network.gateway", networkConfiguration.getGateway());
        this.save(NETWORK_BRIDGE_ENABLED, networkConfiguration.getBridgeConfiguration().isEnabled());
        this.save(NETWORK_BRIDGE_DHCP, networkConfiguration.getBridgeConfiguration().isDhcp());
        this.save(NETWORK_BRIDGE_ADDRESS, networkConfiguration.getBridgeConfiguration().getAddress());
        this.save(NETWORK_BRIDGE_NETMASK, networkConfiguration.getBridgeConfiguration().getNetmask());
        this.save(NETWORK_INTERFACES, Joiner.on((String)";").join(networkConfiguration.getInterfaces()));
        for (NetworkInterfaceConfigurationEntry entry : networkConfiguration.getInterfaces()) {
            this.save(String.format("%s%s.dhcp", NETWORK_INTERFACE_PREFIX, entry.getInterfaceName()), entry.getNetworkInterface().isDhcp());
            this.save(String.format("%s%s.address", NETWORK_INTERFACE_PREFIX, entry.getInterfaceName()), entry.getNetworkInterface().getAddress());
            this.save(String.format("%s%s.netmask", NETWORK_INTERFACE_PREFIX, entry.getInterfaceName()), entry.getNetworkInterface().getNetmask());
        }
    }

    protected MultiNetworkInterfaceConfiguration loadMultiNetworkConfiguration() throws SerializeException {
        BridgeNetworkConfiguration bridgeConfiguration;
        String hostName = this.load("network.hostname", String.class);
        String nameServer1 = this.load("network.nameserver1", String.class);
        String nameServer2 = this.load("network.nameserver2", String.class);
        String gateway = this.load("network.gateway", String.class);
        boolean bridgeEnabeled = this.load(NETWORK_BRIDGE_ENABLED, Boolean.class);
        if (bridgeEnabeled) {
            boolean bridgeDhcp = this.load(NETWORK_BRIDGE_DHCP, Boolean.class);
            if (bridgeDhcp) {
                bridgeConfiguration = new BridgeNetworkConfiguration(true);
            } else {
                String bridgeAddress = this.load(NETWORK_BRIDGE_ADDRESS, String.class);
                String bridgeNetmask = this.load(NETWORK_BRIDGE_NETMASK, String.class);
                bridgeConfiguration = new BridgeNetworkConfiguration(bridgeAddress, bridgeNetmask);
            }
        } else {
            bridgeConfiguration = new BridgeNetworkConfiguration(false);
        }
        Iterable interfaceNames = Splitter.on((String)";").split((CharSequence)this.load(NETWORK_INTERFACES, String.class));
        ArrayList<NetworkInterfaceConfigurationEntry> entries = new ArrayList<NetworkInterfaceConfigurationEntry>();
        for (String interfaceName : interfaceNames) {
            boolean dhcp = this.load(String.format("%s%s.dhcp", NETWORK_INTERFACE_PREFIX, interfaceName), Boolean.class);
            if (dhcp) {
                entries.add(new NetworkInterfaceConfigurationEntry(interfaceName));
                continue;
            }
            String address = this.load(String.format("%s%s.address", NETWORK_INTERFACE_PREFIX, interfaceName), String.class);
            String netmask = this.load(String.format("%s%s.netmask", NETWORK_INTERFACE_PREFIX, interfaceName), String.class);
            entries.add(new NetworkInterfaceConfigurationEntry(interfaceName, new NetworkInterfaceConfiguration(address, netmask)));
        }
        return new MultiNetworkInterfaceConfiguration(hostName, entries, gateway, nameServer1, nameServer2, bridgeConfiguration);
    }

    @Override
    public ApplianceConfiguration newDefaultConfiguration(ApplianceConfiguration oldConfiguration, SystemAttributes systemAttributes) throws SerializeException {
        try {
            return ApplianceConfiguration.newDefaultConfiguration(systemAttributes, oldConfiguration);
        }
        catch (InitializationException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }
}

