/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.storage;

import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.SSLConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AutoConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ProtectionLevel;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ProtectionLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.storage.DefaultConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.core.OutputPower;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class DefaultAccessPointConfigurationStorage
extends DefaultConfigurationStorage<AccessPointConfiguration> {
    static ESLLogger logger = ESLLogger.getLogger(DefaultAccessPointConfigurationStorage.class);
    private static final String AUTOCONFIG_ENABLED = "autoconfig.enabled";
    private static final String THINAPMODE_ENABLED = "thinapmode.enabled";
    private static final String THINAP_PORT = "thinap.port";
    private static final String OUTBOUNDMODE_ENABLED = "outboundmode.enabled";
    private static final String APC_ADDRESS = "apc.address";
    private static final String APC_PORT = "apc.port";
    private static final String THINAP_TLS = "thinap.tls.enabled";
    private static final String THINAP_TLS_STRICT_VERIFICATION = "thinap.tls.strict.enabled";
    private static final String WIRELESS_CHANNEL = "wireless.channel";
    private static final String WIRELESS_MAX_RF_POWER = "wireless.max.power";
    private static final String WIRELESS_RF_POWER = "wireless.power";
    private static final String WIRELESS_WINDOW_SIZE = "wireless.windowsize";
    private static final String MSP_ENABLED = "msp.enabled";
    private static final String MSP_HOST = "msp.host";
    private static final String MSP_PORT = "msp.port";
    private static final String MSP_USERNAME = "msp.username";
    private static final String MSP_PASSWORD = "msp.password";
    private static final String MSP_PATH = "msp.path";
    private static final String MSP_INTERVAL = "msp.interval";
    private static final String BROADCAST_ENABLED = "broadcast.enabled";
    private static final String BROADCAST_INTERVAL = "broadcast.interval";
    private static final String BROADCAST_PORT = "broadcast.port";
    private static final String PROTECTION_LEVEL = "protection.level";

    public DefaultAccessPointConfigurationStorage(PlatformStorage storage) throws SerializeException {
        super(storage);
    }

    @Override
    public void saveConfiguration(AccessPointConfiguration newConfiguration) throws SerializeException {
        this.saveAutoConfiguration(newConfiguration.getAutoConfiguration());
        this.saveWirelessConfiguration(newConfiguration.getWirelessConfiguration());
        this.saveNetworkConfiguration(newConfiguration.getNetworkConfiguration());
        this.saveTimesyncConfiguration(newConfiguration.getTimesyncConfiguration());
        this.saveMSPConfiguration(newConfiguration.getMSPConfiguration());
        this.saveBroadcastConfiguration(newConfiguration.getBroadcastConfiguration());
        this.saveLoggingConfiguration(newConfiguration.getLoggingConfiguration());
        this.saveSSLConfiguration(newConfiguration.getSSLConfiguration());
        this.saveWebserviceConfiguration(newConfiguration.getWebserviceConfiguration());
        this.saveTrustStoreConfiguration(newConfiguration.getTrustStoreConfiguration());
        this.saveThinAPConfiguration(newConfiguration.getThinAPConfiguration());
        this.saveProtectionLevelConfiguration(newConfiguration.getProtectionLevelConfiguration());
        this.save("config.initialized", true);
    }

    private void saveAutoConfiguration(AutoConfiguration autoConfiguration) throws SerializeException {
        this.save(AUTOCONFIG_ENABLED, autoConfiguration.isEnabled());
    }

    protected void saveSSLConfiguration(SSLConfiguration sslConfiguration) throws SerializeException {
        this.save("ssl.clientcert", sslConfiguration.isVerifyClientCertificates());
    }

    private void saveWirelessConfiguration(WirelessConfiguration wirelessConfiguration) throws SerializeException {
        this.save(WIRELESS_CHANNEL, (Object)wirelessConfiguration.getChannel());
        this.save(WIRELESS_MAX_RF_POWER, wirelessConfiguration.getMaxRadioOutputPowerLevel().name());
        this.save(WIRELESS_RF_POWER, wirelessConfiguration.getRadioOutputPowerLevel().name());
        this.save(WIRELESS_WINDOW_SIZE, wirelessConfiguration.getWindowSize());
    }

    private void saveMSPConfiguration(MSPConfiguration mspConfiguration) throws SerializeException {
        this.save(MSP_ENABLED, mspConfiguration.isEnabled());
        this.save(MSP_HOST, mspConfiguration.getHost());
        this.save(MSP_PORT, mspConfiguration.getPort());
        this.save(MSP_USERNAME, mspConfiguration.getUsername());
        this.save(MSP_PASSWORD, mspConfiguration.getPassword());
        this.save(MSP_PATH, mspConfiguration.getPath());
        this.save(MSP_INTERVAL, mspConfiguration.getUploadInterval());
    }

    private void saveBroadcastConfiguration(BroadcastConfiguration broadcastConfiguration) throws SerializeException {
        this.save(BROADCAST_ENABLED, broadcastConfiguration.isBroadcastEnabled());
        this.save(BROADCAST_INTERVAL, broadcastConfiguration.getTimeIntervalInMinutes());
        this.save(BROADCAST_PORT, broadcastConfiguration.getBroadcastPort());
    }

    private void saveThinAPConfiguration(ThinAPConfiguration configuration) throws SerializeException {
        this.save(THINAPMODE_ENABLED, configuration.isModeEnabled());
        this.save(THINAP_PORT, configuration.getPort());
        this.save(OUTBOUNDMODE_ENABLED, configuration.isOutboundModeEnabled());
        this.save(APC_ADDRESS, configuration.getApcAddress());
        this.save(APC_PORT, configuration.getApcPort());
        this.save(THINAP_TLS, configuration.isTLSEnabled());
        this.save(THINAP_TLS_STRICT_VERIFICATION, configuration.isTLSStrictVerficationEnabled());
    }

    private void saveProtectionLevelConfiguration(ProtectionLevelConfiguration protectionLevelConfiguration) throws SerializeException {
        this.save(PROTECTION_LEVEL, (Object)protectionLevelConfiguration.getProtectionLevel());
    }

    @Override
    public AccessPointConfiguration loadConfiguration() throws SerializeException {
        this.waitForInitialization();
        AutoConfiguration autoConfiguration = this.loadAutoConfiguration();
        WirelessConfiguration wirelessConfiguration = this.loadWirelessConfiguration();
        NetworkConfiguration networkConfiguration = this.loadNetworkConfiguration();
        TimesyncConfiguration timesyncConfiguration = this.loadTimesyncConfiguration();
        MSPConfiguration mspConfiguration = this.loadMSPConfiguration();
        BroadcastConfiguration broadcastConfiguration = this.loadBroadcastConfiguration();
        LoggingConfiguration loggingConfiguration = this.loadLoggingConfiguration();
        SSLConfiguration sslConfiguration = this.loadSSLConfiguration();
        WebserviceConfiguration webserviceConfiguration = this.loadWebserviceConfiguration();
        TrustStoreConfiguration trustStoreConfiguration = this.loadTrustStoreConfiguration();
        ThinAPConfiguration thinAPConfiguration = this.loadThinAPConfiguration();
        ProtectionLevelConfiguration protectionLevelConfiguration = this.loadProtectionLevelConfiguration();
        return new AccessPointConfiguration(autoConfiguration, wirelessConfiguration, networkConfiguration, timesyncConfiguration, mspConfiguration, broadcastConfiguration, loggingConfiguration, sslConfiguration, webserviceConfiguration, trustStoreConfiguration, thinAPConfiguration, protectionLevelConfiguration);
    }

    private AutoConfiguration loadAutoConfiguration() throws SerializeException {
        Boolean autoConfigEnabled = this.load(AUTOCONFIG_ENABLED, Boolean.class);
        return autoConfigEnabled == null || autoConfigEnabled == false ? AutoConfiguration.DISABLED : AutoConfiguration.ENABLED;
    }

    protected SSLConfiguration loadSSLConfiguration() throws SerializeException {
        Boolean clientCertificates = this.load("ssl.clientcert", Boolean.class);
        return new SSLConfiguration(clientCertificates != null ? clientCertificates : false);
    }

    private WirelessConfiguration loadWirelessConfiguration() throws SerializeException {
        WirelessChannel channel = this.load(WIRELESS_CHANNEL, WirelessChannel.class);
        String rfPowerString = this.load(WIRELESS_RF_POWER, String.class);
        OutputPower rfPowerSetting = OutputPower.DEFAULT_POWER;
        try {
            if (rfPowerString != null && !rfPowerString.isEmpty()) {
                rfPowerSetting = OutputPower.valueOf(rfPowerString);
            }
        }
        catch (IllegalArgumentException exc) {
            logger.warn("Invalid RF power setting %s: %s", new Object[]{rfPowerSetting, exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        String maxRfPowerString = this.load(WIRELESS_MAX_RF_POWER, String.class);
        OutputPower maxRfPowerSetting = OutputPower.DEFAULT_MAX_POWER;
        try {
            if (maxRfPowerString != null && !maxRfPowerString.isEmpty()) {
                maxRfPowerSetting = OutputPower.valueOf(maxRfPowerString);
            }
        }
        catch (IllegalArgumentException exc) {
            logger.warn("Invalid max RF power setting %s: %s", new Object[]{rfPowerSetting, exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        Integer windowSize = this.load(WIRELESS_WINDOW_SIZE, Integer.class);
        if (windowSize == null || windowSize < 0) {
            windowSize = 14;
        }
        return new WirelessConfiguration(channel, maxRfPowerSetting, rfPowerSetting, windowSize);
    }

    private MSPConfiguration loadMSPConfiguration() throws SerializeException {
        boolean enabled = this.load(MSP_ENABLED, Boolean.class);
        String host = this.load(MSP_HOST, String.class);
        int port = this.load(MSP_PORT, Integer.class);
        String username = this.load(MSP_USERNAME, String.class);
        String password = this.load(MSP_PASSWORD, String.class);
        String path = this.load(MSP_PATH, String.class);
        int uploadIntervalInMinutes = this.load(MSP_INTERVAL, Integer.class);
        return new MSPConfiguration(host, port, username, password, path, uploadIntervalInMinutes, enabled);
    }

    private BroadcastConfiguration loadBroadcastConfiguration() throws SerializeException {
        boolean enabled = this.load(BROADCAST_ENABLED, Boolean.class);
        int intervalInMinutes = this.load(BROADCAST_INTERVAL, Integer.class);
        int port = this.load(BROADCAST_PORT, Integer.class);
        return new BroadcastConfiguration(enabled, intervalInMinutes, port);
    }

    private ThinAPConfiguration loadThinAPConfiguration() throws SerializeException {
        Boolean enabled = this.load(THINAPMODE_ENABLED, Boolean.class);
        boolean modeEnabled = enabled != null ? enabled : false;
        Integer port = this.load(THINAP_PORT, Integer.class);
        int thinApPort = port != null ? port : 7353;
        Boolean outboundEnabled = this.load(OUTBOUNDMODE_ENABLED, Boolean.class);
        boolean outboundModeEnabled = outboundEnabled != null ? outboundEnabled : false;
        String apcAddress = this.load(APC_ADDRESS, String.class);
        Integer tempApcPort = this.load(APC_PORT, Integer.class);
        int apcPort = tempApcPort != null ? tempApcPort : 7353;
        Boolean tlsEnabled = this.load(THINAP_TLS, Boolean.class);
        Boolean tlsStrictVerificationEnabled = this.load(THINAP_TLS_STRICT_VERIFICATION, Boolean.class);
        return new ThinAPConfiguration(modeEnabled, thinApPort, outboundModeEnabled, apcAddress, apcPort, tlsEnabled == null ? false : tlsEnabled, tlsStrictVerificationEnabled == null ? false : tlsStrictVerificationEnabled);
    }

    private ProtectionLevelConfiguration loadProtectionLevelConfiguration() throws SerializeException {
        ProtectionLevel protectionLevel = this.load(PROTECTION_LEVEL, ProtectionLevel.class);
        return new ProtectionLevelConfiguration(protectionLevel);
    }

    @Override
    public AccessPointConfiguration newDefaultConfiguration(AccessPointConfiguration oldConfiguration, SystemAttributes systemAttributes) throws SerializeException {
        return AccessPointConfiguration.newDefaultConfiguration(systemAttributes, oldConfiguration);
    }
}

