/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.storage;

import at.mrdevelopment.esl.admin.platform.config.AbstractApplianceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ApplianceWebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ServiceLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.storage.DefaultConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNIptablesConfiguration;
import at.mrdevelopment.toolkit.xml.SerializeException;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractApplianceConfigurationStorage<C extends AbstractApplianceConfiguration>
extends DefaultConfigurationStorage<C> {
    private static final String WS_JERSEY_PORT_SSL = "ws.port.webservice.ssl";
    private static final String WS_DISABLED_INTERFACES = "ws.interfaces.disabled";
    private static final String SERVICE_LEVEL = "service.level";
    private static final String VPN_ENABLED = "vpn.enabled";
    private static final String VPN_DEVICE = "vpn.dev";
    private static final String VPN_PROTOCOL = "vpn.proto";
    private static final String VPN_REMOTE_ADDRESS = "vpn.remote.address";
    private static final String VPN_REMOTE_PORT = "vpn.remote.port";
    private static final String VPN_CA = "vpn.ca";
    private static final String VPN_CA_CHECKSUM = "vpn.ca.checksum";
    private static final String VPN_CERT = "vpn.cert";
    private static final String VPN_CERT_CHECKSUM = "vpn.cert.checksum";
    private static final String VPN_KEY = "vpn.key";
    private static final String VPN_KEY_CHECKSUM = "vpn.key.checksum";
    private static final String VPN_LOG_LEVEL = "vpn.verb";
    private static final String VPN_CONNECTION_TYPE = "vpn.connection.type";
    private static final String VPN_ADDITIONAL_OPTIONS = "vpn.additional.options";
    private static final String VPN_PREROUTING_DESTINATION = "vpn.prerouting.destination";

    public AbstractApplianceConfigurationStorage(PlatformStorage storage) throws SerializeException {
        super(storage);
    }

    protected void saveApplianceWebserviceConfiguration(ApplianceWebserviceConfiguration webserviceConfiguration) throws SerializeException {
        this.saveWebserviceConfiguration(webserviceConfiguration);
        this.save(WS_JERSEY_PORT_SSL, (Object)webserviceConfiguration.getWebservicePortState());
        this.save(WS_DISABLED_INTERFACES, webserviceConfiguration.hasDisabledInterfaces() ? Joiner.on((String)";").join(webserviceConfiguration.getDisabledInterfaces()) : "");
    }

    protected ApplianceWebserviceConfiguration loadApplianceWebserviceConfiguration() throws SerializeException {
        WebserviceConfiguration webserviceConfiguration = this.loadWebserviceConfiguration();
        String jerseyPortStateString = this.load(WS_JERSEY_PORT_SSL, String.class);
        String disabledInterfacesString = this.load(WS_DISABLED_INTERFACES, String.class);
        ArrayList disabledInteraces = null;
        if (disabledInterfacesString != null && !disabledInterfacesString.isEmpty()) {
            disabledInteraces = Lists.newArrayList((Iterable)Splitter.on((String)";").split((CharSequence)disabledInterfacesString));
        }
        if (jerseyPortStateString.toLowerCase().equals("true") || jerseyPortStateString.toLowerCase().equals("false")) {
            jerseyPortStateString = Boolean.valueOf(jerseyPortStateString) != false ? WebserviceConfiguration.WebserviceState.ENABLED_SSL.toString() : WebserviceConfiguration.WebserviceState.ENABLED_NORMAL.toString();
        }
        return new ApplianceWebserviceConfiguration(webserviceConfiguration, WebserviceConfiguration.WebserviceState.valueOf(jerseyPortStateString), disabledInteraces);
    }

    protected ServiceLevelConfiguration loadServiceLevelConfiguration() throws SerializeException {
        Integer serviceLevel = this.load(SERVICE_LEVEL, Integer.class);
        if (serviceLevel == null) {
            return new ServiceLevelConfiguration();
        }
        return new ServiceLevelConfiguration(serviceLevel);
    }

    protected void saveServerLevelConfiguration(ServiceLevelConfiguration serviceLevelConfiguration) throws SerializeException {
        this.save(SERVICE_LEVEL, serviceLevelConfiguration.getLevel());
    }

    protected void saveClientVPNConfiguration(ClientVPNConfiguration vpnConfiguration) throws SerializeException {
        this.save(VPN_ENABLED, vpnConfiguration.isEnabled());
        this.save(VPN_DEVICE, vpnConfiguration.getDevice());
        this.save(VPN_PROTOCOL, vpnConfiguration.getProtocol());
        this.save(VPN_REMOTE_ADDRESS, vpnConfiguration.getRemoteAddress());
        this.save(VPN_REMOTE_PORT, vpnConfiguration.getRemotePort());
        this.save(VPN_CA, vpnConfiguration.getCa());
        this.save(VPN_CA_CHECKSUM, vpnConfiguration.getCaChecksum());
        this.save(VPN_CERT, vpnConfiguration.getCert());
        this.save(VPN_CERT_CHECKSUM, vpnConfiguration.getCertChecksum());
        this.save(VPN_KEY, vpnConfiguration.getKey());
        this.save(VPN_KEY_CHECKSUM, vpnConfiguration.getKeyChecksum());
        this.save(VPN_LOG_LEVEL, vpnConfiguration.getLogLevel());
        this.save(VPN_CONNECTION_TYPE, vpnConfiguration.getConnectionType());
        this.save(VPN_ADDITIONAL_OPTIONS, Joiner.on((String)";").join(vpnConfiguration.getAdditionalOptions()));
        if (vpnConfiguration instanceof ClientVPNIptablesConfiguration) {
            this.save(VPN_PREROUTING_DESTINATION, ((ClientVPNIptablesConfiguration)vpnConfiguration).getPreroutingDestination());
        } else {
            this.save(VPN_PREROUTING_DESTINATION, "");
        }
    }

    protected ClientVPNConfiguration loadClientVPNConfiguration() throws SerializeException {
        Boolean enabledObject = this.load(VPN_ENABLED, Boolean.class);
        boolean enabled = enabledObject == null ? false : enabledObject;
        String device = this.load(VPN_DEVICE, String.class);
        String protocol = this.load(VPN_PROTOCOL, String.class);
        String remoteAddress = this.load(VPN_REMOTE_ADDRESS, String.class);
        String remotePort = this.load(VPN_REMOTE_PORT, String.class);
        String ca = this.load(VPN_CA, String.class);
        String caChecksum = this.load(VPN_CA_CHECKSUM, String.class);
        String cert = this.load(VPN_CERT, String.class);
        String certChecksum = this.load(VPN_CERT_CHECKSUM, String.class);
        String key = this.load(VPN_KEY, String.class);
        String keyChecksum = this.load(VPN_KEY_CHECKSUM, String.class);
        String logLevel = this.load(VPN_LOG_LEVEL, String.class);
        String additionalOptionsDatabaseValue = this.load(VPN_ADDITIONAL_OPTIONS, String.class);
        ArrayList additionalOptions = additionalOptionsDatabaseValue.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Iterable)Splitter.on((String)";").split((CharSequence)additionalOptionsDatabaseValue));
        String preroutingDestination = this.load(VPN_PREROUTING_DESTINATION, String.class);
        if (preroutingDestination != null && !preroutingDestination.isEmpty()) {
            return new ClientVPNIptablesConfiguration(enabled, device, protocol, remoteAddress, remotePort, ca, caChecksum, cert, certChecksum, key, keyChecksum, logLevel, additionalOptions, preroutingDestination);
        }
        return new ClientVPNConfiguration(enabled, device, protocol, remoteAddress, remotePort, ca, caChecksum, cert, certChecksum, key, keyChecksum, logLevel, additionalOptions);
    }
}

