/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.network;

import at.mrdevelopment.esl.admin.platform.config.network.NetworkInterfaceConfiguration;
import at.mrdevelopment.toolkit.NetworkUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class NetworkInterfaceConfigurationEntry {
    private static final String DEFAULT_BRIDGE_INTERFACE_NAME = "br0";
    public static final Comparator<? super NetworkInterfaceConfigurationEntry> COMPARATOR = new Comparator<NetworkInterfaceConfigurationEntry>(){

        @Override
        public int compare(NetworkInterfaceConfigurationEntry o1, NetworkInterfaceConfigurationEntry o2) {
            return o1.getInterfaceName().compareTo(o2.getInterfaceName());
        }
    };
    private final String interfaceName;
    private final NetworkInterfaceConfiguration networkInterface;

    public NetworkInterfaceConfigurationEntry(String interfaceName) {
        this(interfaceName, new NetworkInterfaceConfiguration());
    }

    public NetworkInterfaceConfigurationEntry(String interfaceName, NetworkInterfaceConfiguration networkInterface) {
        this.interfaceName = interfaceName;
        this.networkInterface = networkInterface;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public NetworkInterfaceConfiguration getNetworkInterface() {
        return this.networkInterface;
    }

    public String toString() {
        return this.getInterfaceName();
    }

    public static List<NetworkInterfaceConfigurationEntry> loadDefaultInterfaces() throws IOException {
        ArrayList<NetworkInterfaceConfigurationEntry> entries = new ArrayList<NetworkInterfaceConfigurationEntry>();
        Collection interfaceNames = NetworkUtils.listInterfaceNames((boolean)true);
        for (String interfaceName : interfaceNames) {
            if (interfaceName.equals(DEFAULT_BRIDGE_INTERFACE_NAME)) continue;
            entries.add(new NetworkInterfaceConfigurationEntry(interfaceName));
        }
        Collections.sort(entries, COMPARATOR);
        return entries;
    }
}

