/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.network;

import at.mrdevelopment.esl.admin.platform.config.network.AbstractNetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkInterfaceConfiguration;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Properties;

public class NetworkConfiguration
extends AbstractNetworkConfiguration {
    static ESLLogger logger = ESLLogger.getLogger(NetworkConfiguration.class);
    public static final String DEFAULT_AP_HOSTNAME = "imagotag-ap";
    private final NetworkInterfaceConfiguration interfaceConfiguration;

    public NetworkConfiguration(String hostName, String address, String netmask, String gateway, String nameServer1, String nameServer2) {
        super(hostName, nameServer1, nameServer2, gateway);
        this.interfaceConfiguration = new NetworkInterfaceConfiguration(address, netmask);
    }

    public NetworkConfiguration(String hostName) {
        super(hostName);
        this.interfaceConfiguration = new NetworkInterfaceConfiguration();
    }

    public NetworkConfiguration(String hostName, String gateway, String nameServer1, String nameServer2) {
        super(hostName, nameServer1, nameServer2, gateway);
        this.interfaceConfiguration = new NetworkInterfaceConfiguration();
    }

    public NetworkConfiguration(String hostName, NetworkConfiguration networkConfiguration) {
        super(hostName, networkConfiguration);
        this.interfaceConfiguration = networkConfiguration.interfaceConfiguration;
    }

    public NetworkConfiguration() {
        this(DEFAULT_AP_HOSTNAME);
    }

    public boolean isDhcp() {
        return this.interfaceConfiguration.isDhcp();
    }

    public String getAddress() {
        return this.interfaceConfiguration.getAddress();
    }

    public String getNetmask() {
        return this.interfaceConfiguration.getNetmask();
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty("hostname", this.getHostName());
        properties.setProperty("dhcp", Boolean.toString(this.interfaceConfiguration.isDhcp()));
        properties.setProperty("address", this.interfaceConfiguration.getAddress() != null ? this.interfaceConfiguration.getAddress() : "");
        properties.setProperty("netmask", this.interfaceConfiguration.getNetmask() != null ? this.interfaceConfiguration.getNetmask() : "");
        properties.setProperty("gateway", this.getGateway() != null ? this.getGateway() : "");
        properties.setProperty("nameserver1", this.getNameServer1() != null ? this.getNameServer1() : "");
        properties.setProperty("nameserver2", this.getNameServer2() != null ? this.getNameServer2() : "");
        return properties;
    }
}

