/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.network;

import at.mrdevelopment.esl.admin.platform.config.network.AbstractNetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.BridgeNetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkInterfaceConfigurationEntry;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class MultiNetworkInterfaceConfiguration
extends AbstractNetworkConfiguration {
    static ESLLogger logger = ESLLogger.getLogger(MultiNetworkInterfaceConfiguration.class);
    private static final String DEFAULT_HOSTNAME = "imagotag-ap";
    private final List<NetworkInterfaceConfigurationEntry> interfaces;
    private final BridgeNetworkConfiguration bridgeConfiguration;

    public MultiNetworkInterfaceConfiguration(String hostName, List<NetworkInterfaceConfigurationEntry> interfaces, String gateway, String nameServer1, String nameServer2, BridgeNetworkConfiguration bridgeConfiguration) {
        super(hostName, nameServer1, nameServer2, gateway);
        this.interfaces = interfaces;
        this.bridgeConfiguration = bridgeConfiguration;
    }

    public MultiNetworkInterfaceConfiguration(String hostName) throws InitializationException {
        super(hostName);
        this.bridgeConfiguration = new BridgeNetworkConfiguration(true);
        try {
            this.interfaces = NetworkInterfaceConfigurationEntry.loadDefaultInterfaces();
        }
        catch (IOException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public MultiNetworkInterfaceConfiguration(String hostName, MultiNetworkInterfaceConfiguration networkConfiguration) {
        super(hostName, networkConfiguration);
        this.bridgeConfiguration = networkConfiguration.getBridgeConfiguration();
        this.interfaces = networkConfiguration.getInterfaces();
    }

    public MultiNetworkInterfaceConfiguration(String hostName, String gateway, String nameServer1, String nameServer2, MultiNetworkInterfaceConfiguration networkConfiguration) {
        super(hostName, nameServer1, nameServer2, gateway);
        this.bridgeConfiguration = networkConfiguration.getBridgeConfiguration();
        this.interfaces = networkConfiguration.getInterfaces();
    }

    public MultiNetworkInterfaceConfiguration() throws InitializationException {
        this(DEFAULT_HOSTNAME);
    }

    public boolean isBridgeSupported() {
        return this.interfaces.size() > 1;
    }

    public List<NetworkInterfaceConfigurationEntry> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty("hostname", this.getHostName());
        properties.setProperty("nameserver1", this.getNameServer1() != null ? this.getNameServer1() : "");
        properties.setProperty("nameserver2", this.getNameServer2() != null ? this.getNameServer2() : "");
        return properties;
    }

    public BridgeNetworkConfiguration getBridgeConfiguration() {
        return this.bridgeConfiguration;
    }
}

