/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.network;

import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractNetworkConfiguration {
    private final String hostName;
    private final String nameServer1;
    private final String nameServer2;
    private final String gateway;

    public AbstractNetworkConfiguration(String hostName, String nameServer1, String nameServer2, String gateway) {
        this.hostName = hostName;
        this.nameServer1 = nameServer1 != null && nameServer1.isEmpty() ? null : nameServer1;
        this.nameServer2 = nameServer2 != null && nameServer2.isEmpty() ? null : nameServer2;
        this.gateway = gateway != null && gateway.isEmpty() ? null : gateway;
    }

    public AbstractNetworkConfiguration(String hostName) {
        this.hostName = hostName;
        this.nameServer1 = null;
        this.nameServer2 = null;
        this.gateway = null;
    }

    public AbstractNetworkConfiguration(String hostName, AbstractNetworkConfiguration networkConfiguration) {
        this.hostName = hostName;
        this.nameServer1 = networkConfiguration.nameServer1;
        this.nameServer2 = networkConfiguration.nameServer2;
        this.gateway = networkConfiguration.gateway;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getNameServer1() {
        return this.nameServer1;
    }

    public String getNameServer2() {
        return this.nameServer2;
    }

    public String getGateway() {
        return this.gateway;
    }

    public Collection<String> getNameServers() {
        ArrayList<String> nameServers = new ArrayList<String>(2);
        if (this.nameServer1 != null && !this.nameServer1.isEmpty()) {
            nameServers.add(this.nameServer1);
        }
        if (this.nameServer2 != null && !this.nameServer2.isEmpty()) {
            nameServers.add(this.nameServer2);
        }
        return nameServers;
    }
}

