/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.manager;

import at.mrdevelopment.esl.admin.ConfigurationChangeManager;
import at.mrdevelopment.esl.admin.platform.config.DateTimeConfiguration;
import at.mrdevelopment.esl.admin.platform.config.GenericPlatformConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimeZoneConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.config.network.AbstractNetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.storage.ConfigurationStorage;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.map.HashedMap;

public abstract class ConfigurationManager<T extends GenericPlatformConfiguration> {
    static ESLLogger logger = ESLLogger.getLogger(ConfigurationManager.class);
    protected final BackendControl backendControl;
    protected final ConfigurationStorage<T> configurationStorage;
    protected final ConfigurationChangeManager configurationChangeManager;
    protected T platformConfiguration;
    protected TimeZoneConfiguration timeZoneConfiguration;

    public ConfigurationManager(BackendControl backendControl, ConfigurationStorage<T> configurationStorage) throws InitializationException, SerializeException {
        this.backendControl = backendControl;
        this.configurationStorage = configurationStorage;
        this.configurationChangeManager = new ConfigurationChangeManager();
        this.timeZoneConfiguration = new TimeZoneConfiguration();
        this.reload();
    }

    public synchronized void reload() throws SerializeException {
        this.platformConfiguration = this.configurationStorage.loadConfiguration();
        this.platformConfiguration.getLoggingConfiguration().apply();
        this.timeZoneConfiguration = new TimeZoneConfiguration();
    }

    public synchronized T getPlatformConfiguration() {
        return this.platformConfiguration;
    }

    public synchronized TimeZoneConfiguration getTimeZoneConfiguration() {
        return this.timeZoneConfiguration;
    }

    public synchronized DateTimeConfiguration getDateTimeConfiguration() {
        return new DateTimeConfiguration();
    }

    public synchronized TimesyncConfiguration getTimesyncConfiguration() {
        return this.platformConfiguration.getTimesyncConfiguration();
    }

    public synchronized LoggingConfiguration getLoggingConfiguration() {
        return this.platformConfiguration.getLoggingConfiguration();
    }

    public synchronized WebserviceConfiguration getWebserviceConfiguration() {
        return this.platformConfiguration.getWebserviceConfiguration();
    }

    public synchronized TrustStoreConfiguration getTrustStoreConfiguration() {
        return this.platformConfiguration.getTrustStoreConfiguration();
    }

    public synchronized ClientVPNConfiguration getClientVPNConfiguration() {
        return this.platformConfiguration.getClientVPNConfiguration();
    }

    public abstract boolean setTimesyncConfiguration(TimesyncConfiguration var1) throws SerializeException;

    public abstract boolean setLoggingConfiguration(LoggingConfiguration var1) throws SerializeException;

    public abstract boolean setPlatformConfiguration(T var1) throws SerializeException;

    public abstract boolean setTimeConfiguration(DateTimeConfiguration var1, TimeZoneConfiguration var2, TimesyncConfiguration var3) throws SerializeException;

    public abstract boolean setWebserviceConfiguration(WebserviceConfiguration var1) throws SerializeException;

    public abstract boolean setTrustStoreConfiguration(TrustStoreConfiguration var1) throws SerializeException;

    public abstract boolean setNetworkConfiguration(AbstractNetworkConfiguration var1) throws SerializeException;

    public abstract boolean setVPNConfiguration(ClientVPNConfiguration var1) throws SerializeException;

    public synchronized boolean setTimeZoneConfiguration(TimeZoneConfiguration newTimeZoneConfiguration) throws SerializeException {
        if (newTimeZoneConfiguration.hasChanged()) {
            HashMap configurationChanges = new HashMap();
            configurationChanges.put(TimeZoneConfiguration.class, newTimeZoneConfiguration.getTaskArgument());
            this.backendControl.applyConfigurationChanges(configurationChanges);
            return true;
        }
        return false;
    }

    public synchronized boolean setDateTimeConfiguration(DateTimeConfiguration newDateTimeConfiguration) throws SerializeException {
        if (newDateTimeConfiguration.hasConfiguration() && newDateTimeConfiguration.hasChanged()) {
            HashedMap configurationChanges = new HashedMap();
            configurationChanges.put(DateTimeConfiguration.class, newDateTimeConfiguration.getTaskArgumentString());
            this.backendControl.applyConfigurationChanges((Map<Class<?>, String>)configurationChanges);
            return true;
        }
        return false;
    }

    protected boolean updateConfiguration(T newConfiguration) throws SerializeException {
        Map<Class<?>, String> configurationChanges = this.getConfigurationChanges(newConfiguration);
        if (configurationChanges.size() > 0) {
            this.configurationStorage.saveConfiguration(newConfiguration);
            this.backendControl.applyConfigurationChanges(configurationChanges);
            this.platformConfiguration = newConfiguration;
            return true;
        }
        return false;
    }

    protected Map<Class<?>, String> getConfigurationChanges(T newConfiguration) throws SerializeException {
        HashMap configurationChanges = new HashMap();
        if (this.configurationChangeManager.hasChanged(this.platformConfiguration.getTimesyncConfiguration(), newConfiguration.getTimesyncConfiguration())) {
            configurationChanges.put(TimesyncConfiguration.class, null);
        }
        if (this.configurationChangeManager.hasChanged(this.platformConfiguration.getLoggingConfiguration(), newConfiguration.getLoggingConfiguration())) {
            configurationChanges.put(LoggingConfiguration.class, null);
            newConfiguration.getLoggingConfiguration().apply();
        }
        if (this.configurationChangeManager.hasChanged(this.platformConfiguration.getWebserviceConfiguration(), newConfiguration.getWebserviceConfiguration())) {
            configurationChanges.put(WebserviceConfiguration.class, null);
        }
        if (this.configurationChangeManager.hasChanged(this.getPlatformConfiguration().getTrustStoreConfiguration(), newConfiguration.getTrustStoreConfiguration())) {
            configurationChanges.put(TrustStoreConfiguration.class, null);
        }
        if (this.configurationChangeManager.hasChanged(this.getPlatformConfiguration().getClientVPNConfiguration(), newConfiguration.getClientVPNConfiguration())) {
            configurationChanges.put(ClientVPNConfiguration.class, null);
        }
        return configurationChanges;
    }
}

