/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.control;

import at.mrdevelopment.esl.admin.platform.BackendTaskInfo;
import at.mrdevelopment.esl.admin.platform.BackendTaskStatus;
import at.mrdevelopment.esl.admin.platform.config.DateTimeConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.SSLConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimeZoneConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.control.BackendControl;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class DefaultBackendControl
implements BackendControl {
    static ESLLogger logger = ESLLogger.getLogger(DefaultBackendControl.class);
    protected static final int TASK_TIMEOUT_IN_SECONDS = 15;
    protected static final int LONGER_TASK_TIMEOUT_IN_SECONDS = 120;
    private final PlatformStorage storage;
    private final boolean asynchronous;

    public DefaultBackendControl(PlatformStorage platformStorage, boolean asynchronous) throws InitializationException {
        this.storage = platformStorage;
        this.asynchronous = asynchronous;
    }

    @Override
    public BackendTaskStatus applyConfigurationChanges(Map<Class<?>, String> configurationChanges) throws SerializeException {
        return this.addBackendTasks(this.generateBackendTasks(configurationChanges));
    }

    @Override
    public BackendTaskStatus applyAllConfigurations() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ApplyConfigurationTask"), true);
    }

    protected List<BackendTaskInfo> generateBackendTasks(Map<Class<?>, String> configurationChanges) {
        ArrayList<BackendTaskInfo> tasks = new ArrayList<BackendTaskInfo>(configurationChanges.size());
        for (Class<?> configurationChange : configurationChanges.keySet()) {
            if (configurationChange == TimesyncConfiguration.class) {
                tasks.add(new BackendTaskInfo("TimesyncTask"));
                continue;
            }
            if (configurationChange == LoggingConfiguration.class) {
                tasks.add(new BackendTaskInfo("LoggingTask"));
                continue;
            }
            if (configurationChange == DateTimeConfiguration.class) {
                tasks.add(new BackendTaskInfo("DateTimeTask", configurationChanges.get(configurationChange)));
                continue;
            }
            if (configurationChange == TimeZoneConfiguration.class) {
                tasks.add(new BackendTaskInfo("TimeZoneTask", configurationChanges.get(configurationChange)));
                continue;
            }
            if (configurationChange == SSLConfiguration.class) {
                tasks.add(new BackendTaskInfo("SSLTask"));
                continue;
            }
            if (configurationChange == WebserviceConfiguration.class) {
                tasks.add(new BackendTaskInfo("WebserviceTask"));
                continue;
            }
            if (configurationChange != TrustStoreConfiguration.class) continue;
            tasks.add(new BackendTaskInfo("TrustStoreTask"));
        }
        return tasks;
    }

    @Override
    public BackendTaskStatus initSystemShutdown() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("SystemShutdownTask"));
    }

    @Override
    public BackendTaskStatus initSystemReboot() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("SystemRebootTask"));
    }

    @Override
    public BackendTaskStatus initServiceRestart() throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("ServiceRestartTask"));
    }

    @Override
    public BackendTaskStatus initServiceShutdown() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ServiceShutdownTask"));
    }

    @Override
    public BackendTaskStatus initRestoreToFactoryDefaults() throws SerializeException {
        return this.addBackendTaskWithTimeout(new BackendTaskInfo("FactoryResetTask"), 120);
    }

    @Override
    public BackendTaskStatus initRestoreToFactoryDefaultsAndReboot() throws SerializeException {
        return this.addBackendTaskWithTimeout(new BackendTaskInfo("FactoryResetAndRebootTask"), 120);
    }

    @Override
    public BackendTaskStatus initSoftwareUpdateAndReboot(String updatePackageFilename) throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("SoftwareUpdateAndRebootTask", updatePackageFilename));
    }

    @Override
    public BackendTaskStatus initSoftwareUpdate(String updatePackageFilename) throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("SoftwareUpdateTask", updatePackageFilename));
    }

    @Override
    public long initSoftwareUpdateAsync(String updatePackageFilename) throws SerializeException {
        return this.scheduleAndReturnBackendTask(new BackendTaskInfo("SoftwareUpdateAndRebootTask", updatePackageFilename));
    }

    @Override
    public BackendTaskStatus initImageInitialization() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ImageInitializationTask"));
    }

    @Override
    public BackendTaskStatus initConfigurationUpdate(String configurationFilename) throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ConfigurationUpdateTask", configurationFilename));
    }

    @Override
    public BackendTaskStatus initVPNConfigurationAndReboot(String configurationPackageFilename) throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("VPNConfigurationAndRebootTask", configurationPackageFilename));
    }

    @Override
    public BackendTaskStatus initClearVPNConfigurationAndReboot() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ClearVPNConfigurationAndRebootTask"));
    }

    public void initProvisioningCertificate() throws SerializeException {
        this.addBackendTask(new BackendTaskInfo("ProvisioningCertificateExecutableTask"), false, true, 15);
    }

    private BackendTaskStatus addBackendTask(BackendTaskInfo taskInfo, boolean asynchronous) throws SerializeException {
        return this.addBackendTask(taskInfo, asynchronous, true);
    }

    private BackendTaskStatus addBackendTask(BackendTaskInfo taskInfo, boolean asynchronous, boolean withTimeout) throws SerializeException {
        return this.addBackendTask(taskInfo, asynchronous, withTimeout, 15);
    }

    private BackendTaskStatus addBackendTask(BackendTaskInfo taskInfo, boolean asynchronous, boolean withTimeout, int timeoutInSeconds) throws SerializeException {
        if (asynchronous) {
            return this.scheduleBackendTask(taskInfo);
        }
        return this.executeBackendTask(taskInfo, withTimeout, timeoutInSeconds);
    }

    protected BackendTaskStatus addBackendTask(BackendTaskInfo taskInfo) throws SerializeException {
        return this.addBackendTask(taskInfo, this.asynchronous);
    }

    protected BackendTaskStatus addBackendTaskWithoutTimeout(BackendTaskInfo taskInfo) throws SerializeException {
        return this.addBackendTask(taskInfo, this.asynchronous, false);
    }

    protected BackendTaskStatus addBackendTaskWithTimeout(BackendTaskInfo taskInfo, int timeoutInSeconds) throws SerializeException {
        return this.addBackendTask(taskInfo, this.asynchronous, true, timeoutInSeconds);
    }

    private BackendTaskStatus addBackendTasks(List<BackendTaskInfo> tasks) throws SerializeException {
        if (this.asynchronous) {
            for (BackendTaskInfo taskInfo : tasks) {
                this.scheduleBackendTask(taskInfo);
            }
            return BackendTaskStatus.SCHEDULED;
        }
        BackendTaskStatus returnStatus = BackendTaskStatus.SUCCESSFUL;
        for (BackendTaskInfo taskInfo : tasks) {
            BackendTaskStatus taskStatus = this.executeBackendTask(taskInfo);
            if (taskStatus == BackendTaskStatus.SUCCESSFUL) continue;
            returnStatus = taskStatus;
        }
        return returnStatus;
    }

    private BackendTaskStatus scheduleBackendTask(BackendTaskInfo taskInfo) throws SerializeException {
        this.storage.insertTask(taskInfo);
        return BackendTaskStatus.SCHEDULED;
    }

    private long scheduleAndReturnBackendTask(BackendTaskInfo taskInfo) throws SerializeException {
        return this.storage.insertTask(taskInfo);
    }

    private BackendTaskStatus executeBackendTask(BackendTaskInfo taskInfo) throws SerializeException {
        return this.executeBackendTask(taskInfo, true, 15);
    }

    private BackendTaskStatus executeBackendTask(BackendTaskInfo taskInfo, boolean withTimeout, int timeoutInSeconds) throws SerializeException {
        BackendTaskInfo taskResult;
        long id = this.storage.insertTask(taskInfo);
        DateTime timeout = DateTime.now().plusSeconds(timeoutInSeconds);
        do {
            if (!withTimeout || !timeout.isBeforeNow()) continue;
            return BackendTaskStatus.TIMEOUT;
        } while (!(taskResult = this.storage.queryTask(id)).isFinished());
        return taskResult.getStatus();
    }

    @Override
    public List<BackendTaskInfo> getTasks() throws SerializeException {
        return this.storage.queryTasks();
    }

    @Override
    public Map<String, String> getConfiguration() throws SerializeException {
        return this.storage.queryConfiguration();
    }
}

