/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.control;

import at.mrdevelopment.esl.admin.platform.BackendTaskInfo;
import at.mrdevelopment.esl.admin.platform.BackendTaskStatus;
import at.mrdevelopment.esl.admin.platform.config.LowFrequencyDriverConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ServiceLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.control.DefaultBackendControl;
import at.mrdevelopment.esl.admin.platform.config.network.MultiNetworkInterfaceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.CompressType;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultApplianceBackendControl
extends DefaultBackendControl {
    public DefaultApplianceBackendControl(PlatformStorage platformStorage, boolean asynchronous) throws InitializationException {
        super(platformStorage, asynchronous);
    }

    @Override
    protected List<BackendTaskInfo> generateBackendTasks(Map<Class<?>, String> configurationChanges) {
        ArrayList<BackendTaskInfo> tasks = new ArrayList<BackendTaskInfo>(configurationChanges.size());
        for (Class<?> configurationChange : configurationChanges.keySet()) {
            if (configurationChange == MultiNetworkInterfaceConfiguration.class) {
                tasks.add(new BackendTaskInfo("NetworkTask"));
                continue;
            }
            if (configurationChange == NetworkConfiguration.class) {
                tasks.add(new BackendTaskInfo("NetworkTask"));
                continue;
            }
            if (configurationChange == LowFrequencyDriverConfiguration.class) {
                tasks.add(new BackendTaskInfo("LowFrequencyTask"));
                continue;
            }
            if (configurationChange == ServiceLevelConfiguration.class) {
                tasks.add(new BackendTaskInfo("ServiceLevelTask"));
                continue;
            }
            if (configurationChange != ClientVPNConfiguration.class) continue;
            tasks.add(new BackendTaskInfo("ClientVPNTask"));
        }
        tasks.addAll(super.generateBackendTasks(configurationChanges));
        return tasks;
    }

    public BackendTaskStatus initClearData() throws SerializeException {
        return this.addBackendTaskWithTimeout(new BackendTaskInfo("ClearDataTask"), 120);
    }

    public BackendTaskStatus createBackup(String backupFolder) throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("CreateBackupTask", backupFolder));
    }

    public BackendTaskStatus restoreBackup(String backupFile) throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("RestoreBackupTask", backupFile));
    }

    public BackendTaskStatus verifyBackup(String backupFile) throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("VerifyBackupTask", backupFile));
    }

    public BackendTaskStatus initKeyStoreUpdate(String keyStoreFile) throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("UpdateKeyStoreTask", keyStoreFile));
    }

    public BackendTaskStatus initClearAllAndReboot() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ClearAllAndRebootTask"));
    }

    public BackendTaskStatus initClearDataAndReboot() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ClearDataAndRebootTask"));
    }

    public BackendTaskStatus initClearAll() throws SerializeException {
        return this.addBackendTaskWithTimeout(new BackendTaskInfo("ClearAllTask"), 120);
    }

    public BackendTaskStatus exportData(String exportFile) throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("ExportDataTask", exportFile));
    }

    public BackendTaskStatus exportDataAndRestart(String exportFile) throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("ExportDataAndRestartTask", exportFile));
    }

    public BackendTaskStatus importData(String importFile) throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("ImportDataTask", importFile));
    }

    public BackendTaskStatus cleanupDatabase() throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("CleanupDbTask"));
    }

    public BackendTaskStatus cleanupData() throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("CleanupDataTask"));
    }

    public BackendTaskStatus purgeDatabase() throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("PurgeDbTask"));
    }

    public BackendTaskStatus compressDatabase(CompressType compressType) throws SerializeException {
        return this.addBackendTaskWithoutTimeout(new BackendTaskInfo("CompressDbTask", compressType.getArgument()));
    }
}

