/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.control;

import at.mrdevelopment.esl.admin.platform.BackendTaskInfo;
import at.mrdevelopment.esl.admin.platform.BackendTaskStatus;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AutoConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.control.AccessPointBackendControl;
import at.mrdevelopment.esl.admin.platform.config.control.DefaultBackendControl;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultAccessPointBackendControl
extends DefaultBackendControl
implements AccessPointBackendControl {
    public DefaultAccessPointBackendControl(PlatformStorage platformStorage, boolean asynchronous) throws InitializationException {
        super(platformStorage, asynchronous);
    }

    @Override
    protected List<BackendTaskInfo> generateBackendTasks(Map<Class<?>, String> configurationChanges) {
        ArrayList<BackendTaskInfo> tasks = new ArrayList<BackendTaskInfo>(configurationChanges.size());
        for (Class<?> configurationChange : configurationChanges.keySet()) {
            if (configurationChange == NetworkConfiguration.class) {
                tasks.add(new BackendTaskInfo("NetworkTask"));
                continue;
            }
            if (configurationChange == AutoConfiguration.class) {
                tasks.add(new BackendTaskInfo("AutoConfigTask"));
                continue;
            }
            if (configurationChange == WirelessConfiguration.class) {
                tasks.add(new BackendTaskInfo("WirelessTask"));
                continue;
            }
            if (configurationChange == MSPConfiguration.class) {
                tasks.add(new BackendTaskInfo("MSPTask"));
                continue;
            }
            if (configurationChange != BroadcastConfiguration.class) continue;
            tasks.add(new BackendTaskInfo("BroadcastTask"));
        }
        tasks.addAll(super.generateBackendTasks(configurationChanges));
        return tasks;
    }

    @Override
    public BackendTaskStatus initFirmwareUpdate(String firmwareFilename) throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("FirmwareUpdateTask", firmwareFilename));
    }

    @Override
    public BackendTaskStatus initCommunicationDaemonRestart() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("CommunicationDaemonRestartTask"));
    }

    @Override
    public BackendTaskStatus initCommunicationDaemonShutdown() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("CommunicationDaemonShutdownTask"));
    }

    @Override
    public BackendTaskStatus initCreateESLEnvironmentFile() throws SerializeException {
        return this.addBackendTaskWithTimeout(new BackendTaskInfo("CreateESLEnvironmentFileExecutableTask"), 120);
    }

    @Override
    public BackendTaskStatus initThinAPTLSUpdate(String certificateArchive) throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("CommunicationDaemonTLSUpdateTask", certificateArchive));
    }

    @Override
    public BackendTaskStatus initThinAPTLSReset() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("CommunicationDaemonTLSResetTask"));
    }
}

