/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.accesspoint;

import at.mrdevelopment.esl.core.OutputPower;
import at.mrdevelopment.esl.core.WirelessChannel;

public class WirelessConfiguration {
    public static final int DEFAULT_WINDOW_SIZE = 14;
    public static final OutputPower DEFAULT_FCC_POWER_SETTING = OutputPower.C;
    private static final int DEFAULT_FCC_WINDOW_SIZE = 7;
    private final WirelessChannel channel;
    private final OutputPower maxOutputPower;
    private final OutputPower outputPower;
    private final int windowSize;
    private final int payloadSize;

    public static WirelessConfiguration createWithMaxOutputPower(WirelessConfiguration wirelessConfiguration, OutputPower maxOutputPower) {
        return new WirelessConfiguration(wirelessConfiguration.getChannel(), maxOutputPower, maxOutputPower, wirelessConfiguration.getWindowSize());
    }

    public static WirelessConfiguration createWithMaxOutputPowerAndWindowSize(WirelessConfiguration wirelessConfiguration, OutputPower maxOutputPower, int windowSize) {
        return new WirelessConfiguration(wirelessConfiguration.getChannel(), maxOutputPower, maxOutputPower, windowSize);
    }

    public WirelessConfiguration() {
        this(null);
    }

    public WirelessConfiguration(WirelessChannel channel) {
        this(channel, OutputPower.DEFAULT_MAX_POWER, OutputPower.DEFAULT_POWER, 14);
    }

    public WirelessConfiguration(WirelessConfiguration wirelessConfiguration, WirelessChannel channel) {
        this(channel, wirelessConfiguration.getMaxRadioOutputPowerLevel(), wirelessConfiguration.getRadioOutputPowerLevel(), wirelessConfiguration.getWindowSize());
    }

    public WirelessConfiguration(WirelessConfiguration wirelessConfiguration, OutputPower outputPower) {
        this(wirelessConfiguration.getChannel(), wirelessConfiguration.getMaxRadioOutputPowerLevel(), outputPower, wirelessConfiguration.getWindowSize());
    }

    public WirelessConfiguration(WirelessConfiguration wirelessConfiguration, int windowSize) {
        this(wirelessConfiguration.getChannel(), wirelessConfiguration.getMaxRadioOutputPowerLevel(), wirelessConfiguration.getRadioOutputPowerLevel(), windowSize);
    }

    public WirelessConfiguration(WirelessChannel channel, OutputPower maxOutputPower, OutputPower outputPower, int windowSize) {
        this.channel = channel;
        this.maxOutputPower = maxOutputPower;
        this.outputPower = outputPower;
        this.windowSize = windowSize;
        this.payloadSize = 32;
    }

    public WirelessChannel getChannel() {
        return this.channel;
    }

    public OutputPower getMaxRadioOutputPowerLevel() {
        return this.maxOutputPower;
    }

    public OutputPower getRadioOutputPowerLevel() {
        return this.outputPower;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getPayloadSize() {
        return this.payloadSize;
    }

    public boolean isFCCCompliant() {
        return this.windowSize == 7 && this.getMaxRadioOutputPowerLevel().getMilliWatts() <= DEFAULT_FCC_POWER_SETTING.getMilliWatts() && this.getRadioOutputPowerLevel().getMilliWatts() <= DEFAULT_FCC_POWER_SETTING.getMilliWatts();
    }
}

