/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.accesspoint;

public class ThinAPConfiguration {
    public static final int THINAP_DEFAULT_PORT = 7353;
    public static final int APC_DEFAULT_PORT = 7353;
    private final Boolean modeEnabled;
    private final int port;
    private final Boolean outboundModeEnabled;
    private final String apcAddress;
    private final int apcPort;
    private final boolean tlsEnabled;
    private final boolean tlsStrictVerificationEnabled;

    public ThinAPConfiguration(int port) {
        this.modeEnabled = null;
        this.port = port;
        this.outboundModeEnabled = null;
        this.apcAddress = "";
        this.apcPort = 7353;
        this.tlsEnabled = false;
        this.tlsStrictVerificationEnabled = false;
    }

    public ThinAPConfiguration(boolean enabled, int port) {
        this.modeEnabled = enabled;
        this.port = port;
        this.outboundModeEnabled = Boolean.FALSE;
        this.apcAddress = "";
        this.apcPort = 7353;
        this.tlsEnabled = false;
        this.tlsStrictVerificationEnabled = false;
    }

    public ThinAPConfiguration(boolean thinApModeEnabled, int thinApPort, boolean outboundModeEnabled, String apcAddress, int apcPort, boolean tlsEnabled, boolean tlsStrictVerification) {
        this.modeEnabled = thinApModeEnabled;
        this.port = thinApPort;
        this.outboundModeEnabled = outboundModeEnabled;
        this.apcAddress = apcAddress;
        this.apcPort = apcPort;
        this.tlsEnabled = tlsEnabled;
        this.tlsStrictVerificationEnabled = tlsStrictVerification;
    }

    public ThinAPConfiguration(ThinAPConfiguration oldConfig, String newApcAddress, int newApcPort) {
        this.modeEnabled = oldConfig.modeEnabled;
        this.port = oldConfig.port;
        this.outboundModeEnabled = oldConfig.outboundModeEnabled;
        this.tlsEnabled = oldConfig.tlsEnabled;
        this.tlsStrictVerificationEnabled = oldConfig.tlsStrictVerificationEnabled;
        this.apcAddress = newApcAddress;
        this.apcPort = newApcPort;
    }

    public Boolean isModeEnabled() {
        return this.modeEnabled;
    }

    public int getPort() {
        return this.port;
    }

    public Boolean isOutboundModeEnabled() {
        return this.outboundModeEnabled;
    }

    public String getApcAddress() {
        return this.apcAddress;
    }

    public int getApcPort() {
        return this.apcPort;
    }

    public boolean isTLSEnabled() {
        return this.tlsEnabled;
    }

    public boolean isTLSStrictVerficationEnabled() {
        return this.tlsStrictVerificationEnabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.apcAddress == null ? 0 : this.apcAddress.hashCode());
        result = 31 * result + this.apcPort;
        result = 31 * result + (this.modeEnabled == null ? 0 : this.modeEnabled.hashCode());
        result = 31 * result + new Boolean(this.tlsEnabled).hashCode();
        result = 31 * result + new Boolean(this.tlsStrictVerificationEnabled).hashCode();
        result = 31 * result + (this.outboundModeEnabled == null ? 0 : this.outboundModeEnabled.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    private boolean isRestEqual(ThinAPConfiguration other) {
        if (this.apcAddress == null ? other.apcAddress != null : !this.apcAddress.equals(other.apcAddress)) {
            return false;
        }
        if (this.apcPort != other.apcPort) {
            return false;
        }
        return this.port == other.port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThinAPConfiguration other = (ThinAPConfiguration)obj;
        if (this.modeEnabled == null ? other.modeEnabled != null : !this.modeEnabled.equals(other.modeEnabled)) {
            return false;
        }
        if (this.outboundModeEnabled == null ? other.outboundModeEnabled != null : !this.outboundModeEnabled.equals(other.outboundModeEnabled)) {
            return false;
        }
        if (this.tlsEnabled != other.tlsEnabled) {
            return false;
        }
        if (this.tlsStrictVerificationEnabled != other.tlsStrictVerificationEnabled) {
            return false;
        }
        return this.isRestEqual(other);
    }

    public Difference getDifferenceTo(ThinAPConfiguration other) {
        Difference diff = new Difference();
        diff.setConnectionModeDifferent(this.outboundModeEnabled == null ? other.outboundModeEnabled != null : !this.outboundModeEnabled.equals(other.outboundModeEnabled));
        diff.setThinModeDifferent(this.modeEnabled == null ? other.modeEnabled != null : !this.modeEnabled.equals(other.modeEnabled));
        diff.setTLSDifferent(this.tlsEnabled != other.tlsEnabled);
        diff.setTLSStrictVerificationDifferent(this.tlsStrictVerificationEnabled != other.tlsStrictVerificationEnabled);
        diff.setRemainderDifferent(!this.isRestEqual(other));
        return diff;
    }

    public static ThinAPConfiguration fromOldChangeOutboundMode(ThinAPConfiguration oldConfig, boolean outboundModeEnabled) {
        return outboundModeEnabled ? new ThinAPConfiguration(true, oldConfig.port, outboundModeEnabled, oldConfig.apcAddress, oldConfig.apcPort, oldConfig.tlsEnabled, oldConfig.tlsStrictVerificationEnabled) : new ThinAPConfiguration(oldConfig.modeEnabled, oldConfig.port, outboundModeEnabled, oldConfig.apcAddress, oldConfig.apcPort, oldConfig.tlsEnabled, oldConfig.tlsStrictVerificationEnabled);
    }

    public static ThinAPConfiguration updateApcSettings(ThinAPConfiguration thinAPConfiguration, String apcAddress, int apcPort) {
        return new ThinAPConfiguration(thinAPConfiguration.modeEnabled, thinAPConfiguration.port, thinAPConfiguration.outboundModeEnabled, apcAddress, apcPort, thinAPConfiguration.tlsEnabled, thinAPConfiguration.tlsStrictVerificationEnabled);
    }

    public static ThinAPConfiguration updateTLSSetting(ThinAPConfiguration thinAPConfiguration, boolean tlsEnabled, boolean tlsStrictVerification) {
        return new ThinAPConfiguration(thinAPConfiguration.modeEnabled, thinAPConfiguration.port, thinAPConfiguration.outboundModeEnabled, thinAPConfiguration.apcAddress, thinAPConfiguration.apcPort, tlsEnabled, tlsStrictVerification);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ThinAPConfiguration [modeEnabled=");
        builder.append(this.modeEnabled);
        builder.append(", port=");
        builder.append(this.port);
        builder.append(", outboundModeEnabled=");
        builder.append(this.outboundModeEnabled);
        builder.append(", apcAddress=");
        builder.append(this.apcAddress);
        builder.append(", apcPort=");
        builder.append(this.apcPort);
        builder.append(", tls=");
        builder.append(this.tlsEnabled);
        builder.append("]");
        return builder.toString();
    }

    public class Difference {
        private boolean thinModeDifferent;
        private boolean connectionModeDifferent;
        private boolean remainderDifferent;
        private boolean tlsDifferent;
        private boolean tlsStrictVerificationDifferent;

        void setConnectionModeDifferent(boolean different) {
            this.connectionModeDifferent = different;
        }

        void setThinModeDifferent(boolean different) {
            this.thinModeDifferent = different;
        }

        void setRemainderDifferent(boolean different) {
            this.remainderDifferent = different;
        }

        void setTLSDifferent(boolean different) {
            this.tlsDifferent = different;
        }

        void setTLSStrictVerificationDifferent(boolean different) {
            this.tlsStrictVerificationDifferent = different;
        }

        public boolean isDifferent() {
            return this.thinModeDifferent || this.connectionModeDifferent || this.remainderDifferent || this.tlsDifferent || this.tlsStrictVerificationDifferent;
        }

        public boolean isThinModeDifferent() {
            return this.thinModeDifferent;
        }

        public boolean isConnectionModeDifferent() {
            return this.connectionModeDifferent;
        }

        public boolean isTLSDifferent() {
            return this.tlsDifferent;
        }

        public boolean isTLSStrictVerificationDifferent() {
            return this.tlsStrictVerificationDifferent;
        }
    }
}

