/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.accesspoint;

import at.mrdevelopment.esl.core.ESLSystemDefaults;
import java.util.Properties;

public class BroadcastConfiguration {
    public static int DEFAULT_DISCOVERY_BROADCAST_INTERVAL_IN_MINUTES = 2;
    private final boolean broadcastEnabled;
    private final int timeIntervalInMinutes;
    private final int broadcastPort;

    public BroadcastConfiguration() {
        this(true);
    }

    public BroadcastConfiguration(boolean broadcastEnabled) {
        this(broadcastEnabled, DEFAULT_DISCOVERY_BROADCAST_INTERVAL_IN_MINUTES, ESLSystemDefaults.DEFAULT_DISCOVERY_BROADCAST_PORT);
    }

    public BroadcastConfiguration(boolean broadcastEnabled, int timeIntervalInMinutes, int broadcastPort) {
        this.broadcastEnabled = broadcastEnabled;
        this.timeIntervalInMinutes = timeIntervalInMinutes;
        this.broadcastPort = broadcastPort;
    }

    public int getTimeIntervalInMinutes() {
        return this.timeIntervalInMinutes;
    }

    public boolean isBroadcastEnabled() {
        return this.broadcastEnabled;
    }

    public int getBroadcastPort() {
        return this.broadcastPort;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty("timeIntervalInMinutes", String.valueOf(this.timeIntervalInMinutes));
        properties.setProperty("broadcastEnabled", Boolean.toString(this.broadcastEnabled));
        properties.setProperty("port", String.valueOf(this.broadcastPort));
        return properties;
    }
}

