/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config.accesspoint;

import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.PlatformConfiguration;
import at.mrdevelopment.esl.admin.platform.config.SSLConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AutoConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ProtectionLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.generic.GenericAccessPointConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.msp.MSPConfiguration;

public class AccessPointConfiguration
extends PlatformConfiguration
implements GenericAccessPointConfiguration {
    private final ThinAPConfiguration thinAPConfiguration;
    private final AutoConfiguration autoConfiguration;
    private final WirelessConfiguration wirelessConfiguration;
    private final MSPConfiguration mspConfiguration;
    private final BroadcastConfiguration broadcastConfiguration;
    private final NetworkConfiguration networkConfiguration;
    protected final SSLConfiguration sslConfiguration;
    private final ProtectionLevelConfiguration protectionLevelConfiguration;

    public static AccessPointConfiguration newDefaultConfiguration(SystemAttributes systemAttributes, AccessPointConfiguration oldAccessPointConfiguration) {
        AutoConfiguration autoConfiguration = AutoConfiguration.ENABLED;
        WirelessConfiguration wirelessConfiguration = oldAccessPointConfiguration != null ? WirelessConfiguration.createWithMaxOutputPowerAndWindowSize(new WirelessConfiguration(), oldAccessPointConfiguration.getWirelessConfiguration().getMaxRadioOutputPowerLevel(), oldAccessPointConfiguration.getWirelessConfiguration().getWindowSize()) : new WirelessConfiguration();
        NetworkConfiguration networkConfiguration = AccessPointConfiguration.newDefaultNetworkConfiguration(systemAttributes);
        TimesyncConfiguration timesyncConfiguration = new TimesyncConfiguration();
        MSPConfiguration mspConfiguration = new MSPConfiguration();
        BroadcastConfiguration broadcastConfiguration = new BroadcastConfiguration();
        LoggingConfiguration loggingConfiguration = new LoggingConfiguration();
        SSLConfiguration sslConfiguration = new SSLConfiguration();
        WebserviceConfiguration webserviceConfiguration = new WebserviceConfiguration();
        TrustStoreConfiguration trustStoreConfiguration = new TrustStoreConfiguration();
        ThinAPConfiguration thinAPConfiguration = new ThinAPConfiguration(false, 7353);
        ProtectionLevelConfiguration protectionLevelConfiguration = new ProtectionLevelConfiguration();
        return new AccessPointConfiguration(autoConfiguration, wirelessConfiguration, networkConfiguration, timesyncConfiguration, mspConfiguration, broadcastConfiguration, loggingConfiguration, sslConfiguration, webserviceConfiguration, trustStoreConfiguration, thinAPConfiguration, protectionLevelConfiguration);
    }

    public AccessPointConfiguration(AutoConfiguration autoConfiguration, WirelessConfiguration wirelessConfiguration, NetworkConfiguration networkConfiguration, TimesyncConfiguration timesyncConfiguration, MSPConfiguration mspConfiguration, BroadcastConfiguration broadcastConfiguration, LoggingConfiguration loggingConfiguration, SSLConfiguration sslConfiguration, WebserviceConfiguration webserviceConfiguration, TrustStoreConfiguration trustStoreConfiguration, ThinAPConfiguration thinAPConfiguration, ProtectionLevelConfiguration protectionLevelConfiguration) {
        super(timesyncConfiguration, loggingConfiguration, webserviceConfiguration, trustStoreConfiguration, networkConfiguration);
        this.sslConfiguration = sslConfiguration;
        this.networkConfiguration = networkConfiguration;
        this.autoConfiguration = autoConfiguration;
        this.wirelessConfiguration = wirelessConfiguration;
        this.mspConfiguration = mspConfiguration;
        this.broadcastConfiguration = broadcastConfiguration;
        this.thinAPConfiguration = thinAPConfiguration;
        this.protectionLevelConfiguration = protectionLevelConfiguration;
    }

    @Override
    public AutoConfiguration getAutoConfiguration() {
        return this.autoConfiguration;
    }

    @Override
    public WirelessConfiguration getWirelessConfiguration() {
        return this.wirelessConfiguration;
    }

    @Override
    public MSPConfiguration getMSPConfiguration() {
        return this.mspConfiguration;
    }

    @Override
    public BroadcastConfiguration getBroadcastConfiguration() {
        return this.broadcastConfiguration;
    }

    @Override
    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public SSLConfiguration getSSLConfiguration() {
        return this.sslConfiguration;
    }

    public ThinAPConfiguration getThinAPConfiguration() {
        return this.thinAPConfiguration;
    }

    public ProtectionLevelConfiguration getProtectionLevelConfiguration() {
        return this.protectionLevelConfiguration;
    }

    @Override
    public String getHostname() {
        return this.getNetworkConfiguration().getHostName();
    }

    public static NetworkConfiguration newDefaultNetworkConfiguration(SystemAttributes systemAttributes) {
        return new NetworkConfiguration(systemAttributes.getDefaultHostname());
    }

    public static NetworkConfiguration newNetworkConfiguration(SystemAttributes systemAttributes, NetworkConfiguration networkConfiguration) {
        return new NetworkConfiguration(systemAttributes.getDefaultHostname(), networkConfiguration);
    }
}

