/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config;

import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.os.linux.LinuxVersionLoader;

public class RuntimeConfiguration {
    private final Info info;
    private final int port;
    private final boolean simulated;
    private final Version kernelVersion;
    private final Version bootLoaderVersion;
    private final Version bootScriptVersion;
    private final Version busyboxVersion;
    private final String applianceBuildNumber;
    private final String distribution;
    private final String biosVersionString;

    public RuntimeConfiguration(Info info, int port, DeviceMode deviceMode, boolean simulated, boolean parseExtendedInformation) throws InitializationException {
        this.info = info;
        this.port = port;
        this.simulated = simulated;
        Version version = this.kernelVersion = simulated || !parseExtendedInformation ? Version.UNDEFINED : LinuxVersionLoader.loadKernelVersion();
        if (deviceMode == DeviceMode.ACCESSPOINT) {
            this.bootLoaderVersion = simulated || !parseExtendedInformation ? Version.UNDEFINED : LinuxVersionLoader.loadUBootVersion();
            this.bootScriptVersion = simulated || !parseExtendedInformation ? Version.UNDEFINED : LinuxVersionLoader.loadBootScriptVersion();
            this.busyboxVersion = simulated || !parseExtendedInformation ? Version.UNDEFINED : LinuxVersionLoader.loadBusyBoxVersion();
        } else {
            this.bootLoaderVersion = Version.UNDEFINED;
            this.bootScriptVersion = Version.UNDEFINED;
            this.busyboxVersion = Version.UNDEFINED;
        }
        if (deviceMode == DeviceMode.CORE_APPLIANCE) {
            this.applianceBuildNumber = simulated || !parseExtendedInformation ? "" : LinuxVersionLoader.loadApplianceBuildNumber();
            this.biosVersionString = simulated || !parseExtendedInformation ? "" : LinuxVersionLoader.loadBiosVersion();
        } else {
            this.applianceBuildNumber = "";
            this.biosVersionString = "";
        }
        this.distribution = simulated || !parseExtendedInformation ? "" : LinuxVersionLoader.loadDistribution();
    }

    public Info getInfo() {
        return this.info;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSimulated() {
        return this.simulated;
    }

    public Version getKernelVersion() {
        return this.kernelVersion;
    }

    public Version getBootLoaderVersion() {
        return this.bootLoaderVersion;
    }

    public Version getBootScriptVersion() {
        return this.bootScriptVersion;
    }

    public Version getBusyboxVersion() {
        return this.busyboxVersion;
    }

    public String getApplianceBuildNumber() {
        return this.applianceBuildNumber;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getBiosVersionString() {
        return this.biosVersionString;
    }
}

