/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config;

import at.mrdevelopment.esl.admin.platform.config.LogLevel;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.SocketAppender;

public class LoggingConfiguration {
    private static final int DEFAULT_SOCKET_APPENDER_PORT = 4560;
    private static final int DEFAULT_SOCKET_APPENDER_DELAY = 10000;
    private static final LogLevel DEFAULT_LOGGING_LEVEL = LogLevel.WARN;
    private static final String SOCKET_APPENDER_NAME = "ESLSocketAppender";
    private final LogLevel logLevel;
    private final boolean socketAppenderEnabled;
    private final String socketRemoteAddress;
    private final int socketAppenderPort;

    public LoggingConfiguration() {
        this(DEFAULT_LOGGING_LEVEL);
    }

    public LoggingConfiguration(LogLevel logLevel) {
        this(logLevel, 4560, null, false);
    }

    public LoggingConfiguration(LogLevel logLevel, int socketAppenderPort, String socketRemoteAddress, boolean socketAppenderEnabled) {
        this.logLevel = logLevel;
        this.socketAppenderPort = socketAppenderPort;
        this.socketRemoteAddress = socketRemoteAddress;
        this.socketAppenderEnabled = socketAppenderEnabled;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public int getSocketAppenderPort() {
        return this.socketAppenderPort;
    }

    public String getSocketRemoteAddress() {
        return this.socketRemoteAddress;
    }

    public boolean isSocketAppenderEnabled() {
        return this.socketAppenderEnabled;
    }

    public void apply() {
        Logger.getRootLogger().removeAppender(SOCKET_APPENDER_NAME);
        if (this.socketAppenderEnabled) {
            this.addSocketAppender(this.socketRemoteAddress, this.socketAppenderPort, 10000);
        }
        LogLog.setQuietMode((boolean)this.socketAppenderEnabled);
        this.changeRootLogLevel(this.logLevel);
    }

    private void addSocketAppender(String socketRemoteAddress, int socketAppenderPort, int socketReconnectionDelay) {
        SocketAppender socketAppender = new SocketAppender(socketRemoteAddress, socketAppenderPort);
        socketAppender.setReconnectionDelay(socketReconnectionDelay);
        AsyncAppender asyncAppender = new AsyncAppender();
        asyncAppender.addAppender((Appender)socketAppender);
        asyncAppender.setName(SOCKET_APPENDER_NAME);
        Logger.getRootLogger().addAppender((Appender)asyncAppender);
    }

    private void changeRootLogLevel(LogLevel logLevel) {
        Logger.getRootLogger().setLevel(Level.toLevel((String)logLevel.toString()));
    }
}

