/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config;

import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.AbstractApplianceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ApplianceWebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LowFrequencyDriverConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ServiceLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;

public class ApplianceMiniConfiguration
extends AbstractApplianceConfiguration {
    private final LowFrequencyDriverConfiguration lowFrequencyDriverConfiguration;
    private final NetworkConfiguration networkConfiguration;
    private final ClientVPNConfiguration vpnConfiguration;

    public ApplianceMiniConfiguration(TimesyncConfiguration timesyncConfiguration, LoggingConfiguration loggingConfiguration, ApplianceWebserviceConfiguration webserviceConfiguration, NetworkConfiguration networkConfiguration, LowFrequencyDriverConfiguration lowFrequencyDriverConfiguration, ServiceLevelConfiguration serviceLevelConfiguration, TrustStoreConfiguration trustStoreConfiguration, ClientVPNConfiguration vpnConfiguration) {
        super(timesyncConfiguration, loggingConfiguration, webserviceConfiguration, serviceLevelConfiguration, trustStoreConfiguration, networkConfiguration);
        this.networkConfiguration = networkConfiguration;
        this.lowFrequencyDriverConfiguration = lowFrequencyDriverConfiguration;
        this.vpnConfiguration = vpnConfiguration;
    }

    public LowFrequencyDriverConfiguration getLowFrequencyDriverConfiguration() {
        return this.lowFrequencyDriverConfiguration;
    }

    @Override
    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public static ApplianceMiniConfiguration newDefaultConfiguration(SystemAttributes systemAttributes, ApplianceMiniConfiguration oldConfiguration) {
        NetworkConfiguration networkConfiguration = new NetworkConfiguration(systemAttributes.getDefaultHostname());
        TimesyncConfiguration timesyncConfiguration = new TimesyncConfiguration();
        LoggingConfiguration loggingConfiguration = new LoggingConfiguration();
        LowFrequencyDriverConfiguration lfConfiguration = new LowFrequencyDriverConfiguration();
        ApplianceWebserviceConfiguration webserviceConfiguraiton = new ApplianceWebserviceConfiguration();
        ServiceLevelConfiguration serviceLevelConfiguration = new ServiceLevelConfiguration();
        TrustStoreConfiguration trustStoreConfiguration = new TrustStoreConfiguration();
        ClientVPNConfiguration vpnConfiguration = new ClientVPNConfiguration();
        return new ApplianceMiniConfiguration(timesyncConfiguration, loggingConfiguration, webserviceConfiguraiton, networkConfiguration, lfConfiguration, serviceLevelConfiguration, trustStoreConfiguration, vpnConfiguration);
    }

    @Override
    public String getHostname() {
        return this.networkConfiguration.getHostName();
    }

    @Override
    public ClientVPNConfiguration getClientVPNConfiguration() {
        return this.vpnConfiguration;
    }
}

