/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform.config;

import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.AbstractApplianceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ApplianceWebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.ServiceLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.MultiNetworkInterfaceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.vpn.ClientVPNConfiguration;
import at.mrdevelopment.toolkit.InitializationException;

public class ApplianceConfiguration
extends AbstractApplianceConfiguration {
    private final MultiNetworkInterfaceConfiguration networkConfiguration;
    private final ClientVPNConfiguration vpnConfiguration;

    public ApplianceConfiguration(MultiNetworkInterfaceConfiguration networkConfiguration, TimesyncConfiguration timesyncConfiguration, LoggingConfiguration loggingConfiguration, ApplianceWebserviceConfiguration webserviceConfiguration, ServiceLevelConfiguration serviceLevelConfiguration, TrustStoreConfiguration trustStoreConfiguration, ClientVPNConfiguration vpnConfiguration) {
        super(timesyncConfiguration, loggingConfiguration, webserviceConfiguration, serviceLevelConfiguration, trustStoreConfiguration, networkConfiguration);
        this.networkConfiguration = networkConfiguration;
        this.vpnConfiguration = vpnConfiguration;
    }

    public static ApplianceConfiguration newDefaultConfiguration(SystemAttributes systemAttributes, ApplianceConfiguration oldConfiguration) throws InitializationException {
        MultiNetworkInterfaceConfiguration networkConfiguration = new MultiNetworkInterfaceConfiguration(systemAttributes.getDefaultHostname());
        TimesyncConfiguration timesyncConfiguration = new TimesyncConfiguration();
        LoggingConfiguration loggingConfiguration = new LoggingConfiguration();
        ApplianceWebserviceConfiguration webserviceConfiguraiton = new ApplianceWebserviceConfiguration();
        ServiceLevelConfiguration serviceLevelConfiguration = new ServiceLevelConfiguration();
        TrustStoreConfiguration trustStoreConfiguration = new TrustStoreConfiguration();
        ClientVPNConfiguration vpnConfiguration = new ClientVPNConfiguration();
        return new ApplianceConfiguration(networkConfiguration, timesyncConfiguration, loggingConfiguration, webserviceConfiguraiton, serviceLevelConfiguration, trustStoreConfiguration, vpnConfiguration);
    }

    @Override
    public ApplianceWebserviceConfiguration getWebserviceConfiguration() {
        return super.getWebserviceConfiguration();
    }

    @Override
    public MultiNetworkInterfaceConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    @Override
    public ClientVPNConfiguration getClientVPNConfiguration() {
        return this.vpnConfiguration;
    }

    @Override
    public String getHostname() {
        return this.networkConfiguration.getHostName();
    }
}

