/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.toolkit.NetworkAddressUtils;
import java.net.Inet4Address;

public class NetworkProperty {
    private final byte[] hardwareAddress;
    private final String address;
    private final String subnetMask;
    private final String broadcast;
    private final String interfaceName;
    private final String adapterName;
    private final Inet4Address inetAddress;
    private final String hardwareAddressString;

    public NetworkProperty(byte[] hardwareAddress, Inet4Address inetAddress, String address, String subnetMask, String broadcast, String interfaceName, String adapterName) {
        this.hardwareAddress = hardwareAddress;
        this.hardwareAddressString = NetworkAddressUtils.hardwareAddressToString((byte[])hardwareAddress);
        this.inetAddress = inetAddress;
        this.address = address;
        this.subnetMask = subnetMask;
        this.broadcast = broadcast;
        this.interfaceName = interfaceName;
        this.adapterName = adapterName;
    }

    public NetworkProperty(String hardwareAddressString, String address, String subnetMask, String broadcast, String interfaceName, String adapterName) {
        this.hardwareAddressString = hardwareAddressString;
        this.hardwareAddress = null;
        this.inetAddress = null;
        this.address = address;
        this.subnetMask = subnetMask;
        this.broadcast = broadcast;
        this.interfaceName = interfaceName;
        this.adapterName = adapterName;
    }

    public byte[] getHardwareAddress() {
        return this.hardwareAddress;
    }

    public String getHardwareAddresString() {
        return this.hardwareAddressString;
    }

    public Inet4Address getInetAddress() {
        return this.inetAddress;
    }

    public String getAddress() {
        return this.address;
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public String getBroadcast() {
        return this.broadcast;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getAdapterName() {
        return this.adapterName;
    }
}

