/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.esl.admin.platform.AccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.config.DeviceMode;
import at.mrdevelopment.esl.core.accesspoint.AccessPointModel;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.provisioning.ClaimId;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.security.Password;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FileStoredSystemAttributes
implements AccessPointSystemAttributes {
    static ESLLogger logger = ESLLogger.getLogger(FileStoredSystemAttributes.class);
    public static final File ACCESSPOINT_ID_FILE = new File("/etc/esl/id");
    public static final File PASSWORD_FILE = new File("/etc/esl/passwd");
    public static final File DEFAULT_PASSWORD_FILE = new File("/etc/esl/defaultpasswd");
    public static final File SERIAL_FILE = new File("/etc/esl/serial");
    public static final File REVISION_FILE = new File("/etc/esl/revision");
    private int accessPointId;
    private int revision;
    private String serial;
    private Password password;
    private Password defaultPassword;
    private final boolean failOnMissingAccessPointId;

    public FileStoredSystemAttributes(boolean failOnMissingAccessPointId) throws InitializationException {
        this.failOnMissingAccessPointId = failOnMissingAccessPointId;
        try {
            this.reload();
        }
        catch (SerializeException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    @Override
    public synchronized AccessPointType getDeviceType() {
        return AccessPointTypeMapping.getType(this.accessPointId);
    }

    private void loadSerial() {
        if (SERIAL_FILE.exists()) {
            try {
                this.serial = FileUtils.read((File)SERIAL_FILE);
            }
            catch (Exception exc) {
                logger.warn("Could not load serial from file.");
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        } else {
            this.serial = "";
        }
    }

    private void loadPassword() throws InitializationException {
        if (PASSWORD_FILE.exists()) {
            try {
                this.password = new Password(FileUtils.read((File)PASSWORD_FILE));
            }
            catch (Exception exc) {
                logger.warn("Could not read password file.");
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                throw new InitializationException((Throwable)exc, "Could not read password file", new Object[0]);
            }
        }
        try {
            this.password = Password.createFromPlainPassword((String)"admin");
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc, "Could not create default password", new Object[0]);
        }
    }

    @Override
    public void loadDefaultPassword() throws InitializationException {
        if (DEFAULT_PASSWORD_FILE.exists()) {
            try {
                this.password = new Password(FileUtils.read((File)DEFAULT_PASSWORD_FILE));
            }
            catch (Exception exc) {
                logger.warn("Could not read default password file.");
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                throw new InitializationException((Throwable)exc, "Could not read default password file", new Object[0]);
            }
        }
        try {
            this.defaultPassword = Password.createFromPlainPassword((String)"admin");
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc, "Could not create default password", new Object[0]);
        }
    }

    private void loadAccessPointId(boolean failOnMissingAccessPointId) throws InitializationException {
        if (ACCESSPOINT_ID_FILE.exists()) {
            String accessPointIdString = "";
            try {
                accessPointIdString = FileUtils.read((File)ACCESSPOINT_ID_FILE);
                this.accessPointId = Integer.valueOf(accessPointIdString);
            }
            catch (Exception exc) {
                logger.warn("Could not read access point ID file.");
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
        if (failOnMissingAccessPointId && this.accessPointId == 0) {
            throw new InitializationException("No access point ID specified", new Object[0]);
        }
    }

    private void loadRevision() {
        if (REVISION_FILE.exists()) {
            String revisionString = "";
            try {
                revisionString = FileUtils.read((File)REVISION_FILE);
                this.revision = Integer.valueOf(revisionString);
            }
            catch (Exception exc) {
                this.revision = 0;
            }
        }
    }

    @Override
    public synchronized int getId() {
        return this.accessPointId;
    }

    @Override
    public synchronized int getRevision() {
        return this.revision;
    }

    @Override
    public synchronized String getSerial() {
        return this.serial;
    }

    @Override
    public synchronized Password getDefaultPassword() {
        return this.defaultPassword;
    }

    @Override
    public synchronized Password getPassword() {
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setId(int accessPointId) throws IOException, IllegalArgumentException {
        if (accessPointId < 0) {
            throw new IllegalArgumentException();
        }
        File accessPointIdFile = ACCESSPOINT_ID_FILE;
        if (accessPointIdFile.exists()) {
            FileStoredSystemAttributes.setFileImmutable(accessPointIdFile, false);
        }
        OutputStreamWriter outWriter = new OutputStreamWriter(new FileOutputStream(accessPointIdFile));
        try {
            outWriter.write(Integer.toString(accessPointId));
        }
        finally {
            ((Writer)outWriter).close();
        }
        FileStoredSystemAttributes.setFileImmutable(accessPointIdFile, true);
        this.accessPointId = accessPointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setSerial(String serial) throws IOException, IllegalArgumentException {
        if (serial == null) {
            throw new IllegalArgumentException();
        }
        File serialFile = SERIAL_FILE;
        if (serialFile.exists()) {
            FileStoredSystemAttributes.setFileImmutable(serialFile, false);
        }
        OutputStreamWriter outWriter = new OutputStreamWriter(new FileOutputStream(serialFile));
        try {
            outWriter.write(serial);
        }
        finally {
            ((Writer)outWriter).close();
        }
        FileStoredSystemAttributes.setFileImmutable(serialFile, true);
        this.serial = serial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setRevision(int revision) throws IOException, IllegalArgumentException {
        if (revision < 0) {
            throw new IllegalArgumentException();
        }
        File revisionFile = REVISION_FILE;
        if (revisionFile.exists()) {
            FileStoredSystemAttributes.setFileImmutable(revisionFile, false);
        }
        OutputStreamWriter outWriter = new OutputStreamWriter(new FileOutputStream(revisionFile));
        try {
            outWriter.write(Integer.toString(revision));
        }
        finally {
            ((Writer)outWriter).close();
        }
        FileStoredSystemAttributes.setFileImmutable(revisionFile, true);
        this.revision = revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setPassword(Password password) throws Exception {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        File passwordFile = PASSWORD_FILE;
        if (passwordFile.exists()) {
            FileStoredSystemAttributes.setFileImmutable(passwordFile, false);
        }
        OutputStreamWriter outWriter = new OutputStreamWriter(new FileOutputStream(passwordFile));
        try {
            outWriter.write(password.getSaltedHash());
        }
        finally {
            ((Writer)outWriter).close();
        }
        FileStoredSystemAttributes.setFileImmutable(passwordFile, true);
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDefaultPassword(Password password) throws Exception {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        File passwordFile = DEFAULT_PASSWORD_FILE;
        if (passwordFile.exists()) {
            FileStoredSystemAttributes.setFileImmutable(passwordFile, false);
        }
        OutputStreamWriter outWriter = new OutputStreamWriter(new FileOutputStream(passwordFile));
        try {
            outWriter.write(password.getSaltedHash());
        }
        finally {
            ((Writer)outWriter).close();
        }
        FileStoredSystemAttributes.setFileImmutable(passwordFile, true);
        this.defaultPassword = password;
    }

    public static void setFileImmutable(File file, boolean immutable) throws IOException {
        String immutableFlag = immutable ? "+" : "-";
        try {
            Process process = Runtime.getRuntime().exec("chattr " + immutableFlag + "i " + file.getPath());
            process.waitFor();
        }
        catch (IOException exc) {
            logger.warn("Failed to set immutable attribute on file %s", new Object[]{file.getPath()});
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isForbidJoin() {
        return false;
    }

    @Override
    public String getDeviceTypeName() {
        return this.getDeviceType().getDeviceName();
    }

    @Override
    public String getDefaultHostname() {
        if (this.getId() > 0) {
            return String.format("ap-%d", this.getId());
        }
        return "imagotag-ap";
    }

    @Override
    public DeviceMode getDeviceMode() {
        return DeviceMode.ACCESSPOINT;
    }

    @Override
    public void setDeviceMode(DeviceMode mode) throws Exception {
    }

    @Override
    public void reload() throws SerializeException, InitializationException {
        this.loadAccessPointId(this.failOnMissingAccessPointId);
        this.loadRevision();
        this.loadSerial();
        this.loadPassword();
        this.loadDefaultPassword();
    }

    @Override
    public void setClaimId(String claimId) throws Exception {
    }

    @Override
    public AccessPointModel getDeviceModel() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public ClaimId getClaimId() {
        throw new UnsupportedOperationException("Not supported");
    }
}

