/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.esl.admin.platform.NetworkProperty;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.NetworkAddressUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.MDC;

public class EnvironmentProperties {
    static ESLLogger logger = ESLLogger.getLogger(EnvironmentProperties.class);
    private final long deviceUUID;
    private final String hardwareAddress;
    private final String address;
    private final String subnetMask;
    private final String broadcast;
    private final String interfaceName;
    private final String adapterName;
    private final String operatingSystem;
    private final String hostName;
    private final String garbageCollector;

    public EnvironmentProperties(boolean parseHostname, boolean ignoreLoopback, boolean ignorePointToPoint, boolean ignoreVirtual) throws InitializationException {
        try {
            NetworkEnvironment network = this.parseNetworkEnvironment(parseHostname, ignoreLoopback, ignorePointToPoint, ignoreVirtual);
            this.deviceUUID = network.deviceUUID;
            this.hardwareAddress = network.networkProperty.getHardwareAddresString();
            this.address = network.networkProperty.getAddress();
            this.subnetMask = network.networkProperty.getSubnetMask();
            this.broadcast = network.networkProperty.getBroadcast();
            this.adapterName = network.networkProperty.getAdapterName();
            this.interfaceName = network.networkProperty.getInterfaceName();
            this.operatingSystem = this.parseOperatingSystem();
            this.hostName = network.hostname;
            this.garbageCollector = this.parseGC();
            this.addMDCLoggingInformation();
        }
        catch (Exception exception) {
            throw new InitializationException((Throwable)exception);
        }
    }

    public EnvironmentProperties(boolean parseHostname) throws InitializationException {
        this(parseHostname, true, true, true);
    }

    private String parseGC() {
        List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
        if (beans != null) {
            Collection gcList = Collections2.transform((Collection)Collections2.filter(beans, (Predicate)new Predicate<GarbageCollectorMXBean>(){

                public boolean apply(GarbageCollectorMXBean bean) {
                    return bean.isValid();
                }
            }), (Function)new Function<GarbageCollectorMXBean, String>(){

                public String apply(GarbageCollectorMXBean bean) {
                    return bean.getName();
                }
            });
            return Joiner.on((String)", ").join((Iterable)gcList);
        }
        return "";
    }

    private NetworkEnvironment parseNetworkEnvironment(boolean parseHostname, boolean ignoreLoopback, boolean ignorePointToPoint, boolean ignoreVirtual) throws UnknownHostException, SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        NetworkEnvironment backupAddress = null;
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            NetworkProperty networkProperty = EnvironmentProperties.parseNetworkProperty(networkInterface, ignoreLoopback, ignorePointToPoint, ignoreVirtual);
            if (networkProperty == null) continue;
            NetworkEnvironment networkEnvironment = new NetworkEnvironment();
            networkEnvironment.networkProperty = networkProperty;
            networkEnvironment.deviceUUID = this.generateUUID(networkProperty.getHardwareAddress());
            String string = networkEnvironment.hostname = parseHostname ? this.parseHostname(networkProperty.getInetAddress().getCanonicalHostName()) : "localhost";
            if (!networkProperty.getInetAddress().isLinkLocalAddress()) {
                return networkEnvironment;
            }
            if (backupAddress != null) continue;
            backupAddress = networkEnvironment;
        }
        if (backupAddress != null) {
            return backupAddress;
        }
        throw new RuntimeException("Could not load network information");
    }

    private String parseOperatingSystem() {
        String osProperty = System.getProperty("os.name").toLowerCase();
        if (osProperty.indexOf("windows") > -1) {
            return "WINDOWS";
        }
        if (osProperty.indexOf("linux") > -1) {
            return "LINUX";
        }
        if (osProperty.indexOf("mac") > -1) {
            return "MAC";
        }
        return "OTHER";
    }

    private String parseHostname(String fallbackHostname) {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getCanonicalHostName();
        }
        catch (UnknownHostException ignore) {
            return fallbackHostname;
        }
    }

    private long generateUUID(byte[] hardwareAddress) {
        long deviceUUID = 0L;
        if (hardwareAddress != null) {
            for (byte addressByte : hardwareAddress) {
                deviceUUID = (long)(addressByte & 0xFF) | deviceUUID << 8;
            }
        }
        return deviceUUID;
    }

    public String getMacAddress() {
        return this.hardwareAddress;
    }

    public String getIPAddress() {
        return this.address;
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public String getBroadcast() {
        return this.broadcast;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getUUID() {
        return Long.toString(this.deviceUUID);
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getGarbageCollector() {
        return this.garbageCollector;
    }

    public static void main(String[] args) throws Exception {
        EnvironmentProperties environmentProperties = new EnvironmentProperties(true);
        System.out.println(environmentProperties.getOperatingSystem());
        System.out.println(environmentProperties.getAdapterName());
        System.out.println(environmentProperties.getUUID());
        System.out.println(environmentProperties.getMacAddress());
        System.out.println(environmentProperties.getIPAddress());
        System.out.println(environmentProperties.getSubnetMask());
        System.out.println(environmentProperties.getBroadcast());
        System.out.println(environmentProperties.getHostName());
        System.out.println(environmentProperties.getGarbageCollector());
    }

    private void addMDCLoggingInformation() {
        MDC.put((String)"ADDRESS", (Object)(this.address != null ? this.address : "localhost"));
    }

    public static NetworkProperty parseNetworkProperty(NetworkInterface networkInterface, boolean ignoreLoopback, boolean ignorePointToPoint, boolean ignoreVirtual) throws UnknownHostException {
        try {
            if (ignoreLoopback && networkInterface.isLoopback() || ignorePointToPoint && networkInterface.isPointToPoint() || ignoreVirtual && networkInterface.isVirtual()) {
                return null;
            }
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                InetAddress address = interfaceAddress.getAddress();
                InetAddress subnetMask = NetworkAddressUtils.networkPrefixToSubnetMask((int)interfaceAddress.getNetworkPrefixLength());
                if (!(address instanceof Inet4Address)) continue;
                return new NetworkProperty(EnvironmentProperties.getHardwareAddress(networkInterface), (Inet4Address)address, address.getHostAddress(), subnetMask.getHostAddress(), NetworkAddressUtils.calculateBroadcastAddress((Inet4Address)((Inet4Address)address), (int)interfaceAddress.getNetworkPrefixLength()).getHostAddress(), networkInterface.getName(), networkInterface.getDisplayName());
            }
        }
        catch (SocketException exception) {
            logger.warn("Failed to open network interface %s", new Object[]{String.format("%s (%s)", networkInterface.getDisplayName(), networkInterface.getName())});
            logger.logExceptionIfDebugEnabled((Throwable)exception);
        }
        return null;
    }

    private static byte[] getHardwareAddress(NetworkInterface networkInterface) {
        try {
            return networkInterface.getHardwareAddress();
        }
        catch (SocketException exception) {
            logger.warn("Failed to open network interface %s", new Object[]{String.format("%s (%s)", networkInterface.getDisplayName(), networkInterface.getName())});
            logger.logExceptionIfDebugEnabled((Throwable)exception);
            return null;
        }
    }

    private static class NetworkEnvironment {
        NetworkProperty networkProperty;
        String hostname;
        long deviceUUID;

        private NetworkEnvironment() {
        }
    }
}

